"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _fs = _interopRequireDefault(require("fs"));
var R = _interopRequireWildcard(require("ramda"));
var _dateFns = require("date-fns");
var _pofile = _interopRequireDefault(require("pofile"));
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const getCreateHeaders = (language = "no") => ({
  "POT-Creation-Date": (0, _dateFns.format)(new Date(), "yyyy-MM-dd HH:mmxxxx"),
  "MIME-Version": "1.0",
  "Content-Type": "text/plain; charset=utf-8",
  "Content-Transfer-Encoding": "8bit",
  "X-Generator": "@lingui/cli",
  Language: language
});
const serialize = (items, options) => R.compose(R.values, R.mapObjIndexed((message, key) => {
  const item = new _pofile.default.Item();
  item.msgid = key;
  item.msgstr = [message.translation];
  item.comments = message.comments || [];
  item.extractedComments = message.extractedComments || [];
  if (message.context) {
    item.msgctxt = message.context;
  }
  if (options.origins !== false) {
    if (message.origin && options.lineNumbers === false) {
      item.references = message.origin.map(([path]) => path);
    } else {
      item.references = message.origin ? message.origin.map(_utils.joinOrigin) : [];
    }
  }
  // @ts-ignore: Figure out how to set this flag
  item.obsolete = message.obsolete;
  item.flags = message.flags ? R.fromPairs(message.flags.map(flag => [flag, true])) : {};
  return item;
}))(items);
const getMessageKey = R.prop("msgid");
const getTranslations = R.prop("msgstr");
const getExtractedComments = R.prop("extractedComments");
const getTranslatorComments = R.prop("comments");
const getMessageContext = R.prop("msgctxt");
const getOrigins = R.prop("references");
const getFlags = R.compose(R.map(R.trim), R.keys, R.dissoc("obsolete"),
// backward-compatibility, remove in 3.x
R.prop("flags"));
const isObsolete = R.either(R.path(["flags", "obsolete"]), R.prop("obsolete"));
const deserialize = R.map(R.applySpec({
  translation: R.compose(R.head, R.defaultTo([]), getTranslations),
  extractedComments: R.compose(R.defaultTo([]), getExtractedComments),
  comments: R.compose(R.defaultTo([]), getTranslatorComments),
  context: R.compose(R.defaultTo(null), getMessageContext),
  obsolete: isObsolete,
  origin: R.compose(R.map(_utils.splitOrigin), R.defaultTo([]), getOrigins),
  flags: getFlags
}));
const validateItems = R.forEach(item => {
  if (R.length(getTranslations(item)) > 1) {
    console.warn("Multiple translations for item with key %s is not supported and it will be ignored.", getMessageKey(item));
  }
});
const indexItems = R.indexBy(getMessageKey);
const po = {
  catalogExtension: ".po",
  write(filename, catalog, options) {
    let po;
    if (_fs.default.existsSync(filename)) {
      const raw = _fs.default.readFileSync(filename).toString();
      po = _pofile.default.parse(raw);
    } else {
      po = new _pofile.default();
      po.headers = getCreateHeaders(options.locale);
      if (options.locale === undefined) {
        delete po.headers.Language;
      }
      po.headerOrder = R.keys(po.headers);
    }
    po.items = serialize(catalog, options);
    (0, _utils.writeFileIfChanged)(filename, po.toString());
  },
  read(filename) {
    const raw = _fs.default.readFileSync(filename).toString();
    return this.parse(raw);
  },
  parse(raw) {
    const po = _pofile.default.parse(raw);
    validateItems(po.items);
    return deserialize(indexItems(po.items));
  }
};
var _default = po;
exports.default = _default;