"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _fs = _interopRequireDefault(require("fs"));
var R = _interopRequireWildcard(require("ramda"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const serialize = R.map(message => message.translation || "");
const deserialize = R.map(translation => ({
  translation,
  obsolete: false,
  message: null,
  origin: []
}));
const minimal = {
  catalogExtension: ".json",
  write(filename, catalog) {
    var _file;
    const messages = serialize(catalog);
    let file = null;
    try {
      file = _fs.default.readFileSync(filename, "utf8");
    } catch (error) {
      if (error.code !== "ENOENT") {
        throw error;
      }
    }
    const shouldUseTrailingNewline = file === null || ((_file = file) === null || _file === void 0 ? void 0 : _file.endsWith("\n"));
    const trailingNewLine = shouldUseTrailingNewline ? "\n" : "";
    _fs.default.writeFileSync(filename, `${JSON.stringify(messages, null, 2)}${trailingNewLine}`);
  },
  read(filename) {
    const raw = _fs.default.readFileSync(filename).toString();
    try {
      const rawCatalog = JSON.parse(raw);
      return deserialize(rawCatalog);
    } catch (e) {
      throw new Error(`Cannot read ${filename}: ${e.message}`);
    }
  },
  parse(content) {
    return deserialize(content);
  }
};
var _default = minimal;
exports.default = _default;