"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = extract;
var _ora = _interopRequireDefault(require("ora"));
var _babel = _interopRequireDefault(require("./babel"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const DEFAULT_EXTRACTORS = [_babel.default];
async function extract(filename, targetPath, options) {
  const extractorsToExtract = options.extractors ?? DEFAULT_EXTRACTORS;
  for (let e of extractorsToExtract) {
    let ext = e;
    if (typeof e === "string") {
      // in case of the user using require.resolve in their extractors, we require that module
      ext = require(e);
    }
    if (ext.default) {
      ext = ext.default;
    }
    if (!ext.match(filename)) continue;
    let spinner;
    if (options.verbose) spinner = (0, _ora.default)().start(filename);
    try {
      await ext.extract(filename, targetPath, options);
      if (options.verbose && spinner) spinner.succeed();
      return true;
    } catch (e) {
      if (options.verbose && spinner) {
        spinner.fail(e.message);
      } else {
        console.error(`Cannot process file ${e.message}`);
      }
      return false;
    }
  }
  return true;
}