---
title: Reference
description: Notifee provides Reference documentation for all publicly available APIs.
---

The public JavaScript API for React Native is written with TypeScript. The Notifee reference documentation is
automatically generated to provide users with further detail into the full API.

# API & Types

The reference documentation is broken down into two categories:

## API

All publicly available methods which can be accessed from the imported library, for example:

```js
import notifee from '@notifee/react-native';

notifee.cancelAllNotifications();
```

View the [Basic Usage](/react-native/docs/usage) documentation for more information.

## Types

Types are those which are publicly available to users to assist when using the library. The types documentation
includes descriptions of individual properties which may not be covered in the general documentation. Types are available
as named exports, for example:

```js
import { AndroidColor, EventType } from '@notifee/react-native';
```

View the [Basic Usage](/react-native/docs/usage) documentation for more information.
