---
title: Overview
description: Overview of Notifee, the documentation guides and reference API.
next: /react-native/docs/environment-support
---

Notifee is a library for React Native, bringing local notification support to both Android &
iOS applications.

# The library

Notifee is a local notifications library and does not integrate with any 3rd party messaging services. This provides
developers greater flexibility on how notifications are managed and integrated with new and existing applications.

The library is a successor to the notifications module in [React Native Firebase v5](https://v5.rnfirebase.io/docs/v5.x.x/notifications/introduction).
The entire library has been reworked from the ground up focusing on new features, testing, documentation and device
compatibility.

# Documentation

Our documentation aims to provide a walkthrough guide to integrating notifee with your app on both Android & iOS platforms.

## Android vs iOS

A lot of the Notifee documentation is broken out into Android Concepts vs iOS Concepts. The underlying APIs & features provided by Android & iOS are very different. Notifee aims to provide first-class
support for both platforms which is why there are separate guides for [iOS](https://notifee.app/react-native/docs/ios/introduction) & [Android](https://notifee.app/react-native/docs/android/introduction).

# Reference API

The Notifee [reference API](/react-native/reference) provides developers with a deep dive into each of the methods
& properties which the API exposes. The reference is generated from [TypeScript](https://www.typescriptlang.org/) & is
Open Source - if you wish to improve any of the types, feel free to submit a [Pull Request](https://github.com/invertase/notifee/pulls)
or file an [Issue](https://github.com/invertase/notifee/issues).
