---
title: Android Notifications
description: Android platform provides an expansive feature set for notifications. Learn about the differences, compatibility and support.
next: /react-native/docs/android/appearance
previous: /react-native/docs/integrations/onesignal
---

The Android API allows for creating rich, styled and highly interactive notifications. Notifications are an important
concept on Android, and frequently receive new updates with each new API version.

Notifee has been designed to integrate with the latest API features, and also provide backwards compatibility for
older Android devices (Android 4.4W (API 20)).

## Android Features

The table below summarizes the various topics to read about to customize your notifications:

| Topic                                                                 |                                                                                                                                 |
| --------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- |
| [Appearance](/react-native/docs/android/appearance)                   | Change the appearance of a notification; icons, colors, visibility, etc.                                                        |
| [Behaviour](/react-native/docs/android/behaviour)                     | Customize how a notification behaves when it is delivered to a device; sound, vibration, lights, etc.                           |
| [Channels & Groups](/react-native/docs/android/channels)              | Organize your notifications into channels & groups to allow users to control how notifications are handled on their device.     |
| [Foreground Service](/react-native/docs/android/foreground-service)   | Long running background tasks can take advantage of Android Foreground Services to display an on-going, prominent notification. |
| [Grouping & Sorting](/react-native/docs/android/grouping-and-sorting) | Group and sort related notifications in a single notification pane.                                                             |
| [Interaction](/react-native/docs/android/interaction)                 | Allow users to interact with your application directly from the notification with actions.                                      |
| [Permissions](/react-native/docs/android/permissions)                 | Check whether notifications are enabled for your app, a channel group, or channel.     
| [Progress Indicators](/react-native/docs/android/progress-indicators) | Show users a progress indicator of an on-going background task, and learn how to keep it updated.                               |
| [Styles](/react-native/docs/android/styles)                           | Style notifications to show richer content, such as expandable images/text, or message conversations.                           |
| [Timers](/react-native/docs/android/timers)                           | Display counting timers on your notification, useful for on-going tasks such as a phone call, or event time remaining.          |
