var {
  useMenuTriggerState
} = require("@react-stately/menu");

var {
  useEffect,
  useMemo,
  useRef,
  useState
} = require("react");

var {
  useControlledState
} = require("@react-stately/utils");

var {
  ListCollection,
  useSingleSelectListState
} = require("@react-stately/list");

var _babelRuntimeHelpersExtends = $parcel$interopDefault(require("@babel/runtime/helpers/extends"));

function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}

/**
 * Provides state management for a combo box component. Handles building a collection
 * of items from props and manages the option selection state of the combo box. In addition, it tracks the input value,
 * focus state, and other properties of the combo box.
 */
function useComboBoxState(props) {
  var _props$defaultInputVa, _props$items, _ref, _props$selectedKey;

  let {
    defaultFilter,
    menuTrigger = 'input',
    allowsEmptyCollection = false,
    allowsCustomValue,
    shouldCloseOnBlur = true
  } = props;
  let [isFocused, setFocusedState] = useState(false);
  let [inputValue, setInputValue] = useControlledState(props.inputValue, (_props$defaultInputVa = props.defaultInputValue) != null ? _props$defaultInputVa : '', props.onInputChange);

  let onSelectionChange = key => {
    if (props.onSelectionChange) {
      props.onSelectionChange(key);
    } // If open state or selectedKey is uncontrolled and key is the same, reset the inputValue and close the menu
    // (scenario: user clicks on already selected option)


    if (props.isOpen === undefined || props.selectedKey === undefined) {
      if (key === selectedKey) {
        resetInputValue();
        triggerState.close();
      }
    }
  };

  let {
    collection,
    selectionManager,
    selectedKey,
    setSelectedKey,
    selectedItem,
    disabledKeys
  } = useSingleSelectListState(_babelRuntimeHelpersExtends({}, props, {
    onSelectionChange,
    items: (_props$items = props.items) != null ? _props$items : props.defaultItems
  }));
  let filteredCollection = useMemo(() => // No default filter if items are controlled.
  props.items != null || !defaultFilter ? collection : $a21047c5b4305a7d5e80cc48828d4cd$var$filterCollection(collection, inputValue, defaultFilter), [collection, inputValue, defaultFilter, props.items]);
  let triggerState = useMenuTriggerState(props);

  let open = focusStrategy => {
    // Prevent open operations from triggering if there is nothing to display
    if (allowsEmptyCollection || filteredCollection.size > 0) {
      triggerState.open(focusStrategy);
    }
  };

  let toggle = focusStrategy => {
    // If the menu is closed and there is nothing to display, early return so toggle isn't called to prevent extraneous onOpenChange
    if (!(allowsEmptyCollection || filteredCollection.size > 0) && !triggerState.isOpen) {
      return;
    }

    triggerState.toggle(focusStrategy);
  };

  let lastValue = useRef(inputValue);

  let resetInputValue = () => {
    var _collection$getItem$t, _collection$getItem;

    let itemText = (_collection$getItem$t = (_collection$getItem = collection.getItem(selectedKey)) == null ? void 0 : _collection$getItem.textValue) != null ? _collection$getItem$t : '';
    lastValue.current = itemText;
    setInputValue(itemText);
  };

  let isInitialRender = useRef(true);
  let lastSelectedKey = useRef((_ref = (_props$selectedKey = props.selectedKey) != null ? _props$selectedKey : props.defaultSelectedKey) != null ? _ref : null);
  useEffect(() => {
    // If open state or inputValue is uncontrolled, open and close automatically when the input value changes,
    // the input is if focused, and there are items in the collection.
    if (isFocused && filteredCollection.size > 0 && !triggerState.isOpen && inputValue !== lastValue.current && menuTrigger !== 'manual' && (props.isOpen === undefined || props.inputValue === undefined)) {
      open();
    } // Close the menu if the collection is empty and either open state or items are uncontrolled.


    if (!allowsEmptyCollection && triggerState.isOpen && filteredCollection.size === 0 && (props.isOpen === undefined || props.items === undefined)) {
      triggerState.close();
    } // Close when an item is selected, if open state or selectedKey is uncontrolled.


    if (selectedKey != null && selectedKey !== lastSelectedKey.current && (props.isOpen === undefined || props.selectedKey === undefined)) {
      triggerState.close();
    } // Clear focused key when input value changes.


    if (inputValue !== lastValue.current) {
      selectionManager.setFocusedKey(null); // Set selectedKey to null when the user clears the input.
      // If controlled, this is the application developer's responsibility.

      if (inputValue === '' && (props.inputValue === undefined || props.selectedKey === undefined)) {
        setSelectedKey(null);
      }
    } // If it is the intial render and inputValue isn't controlled nor has an intial value, set input to match current selected key if any


    if (isInitialRender.current && props.inputValue === undefined && props.defaultInputValue === undefined) {
      resetInputValue();
    } // If the selectedKey changed, update the input value.
    // Do nothing if both inputValue and selectedKey are controlled.
    // In this case, it's the user's responsibility to update inputValue in onSelectionChange. In addition, we preserve the defaultInputValue
    // on initial render, even if it doesn't match the selected item's text.


    if (selectedKey !== lastSelectedKey.current && (props.inputValue === undefined || props.selectedKey === undefined)) {
      resetInputValue();
    } else {
      lastValue.current = inputValue;
    }

    isInitialRender.current = false;
    lastSelectedKey.current = selectedKey;
  });
  useEffect(() => {
    // Reset focused key when the menu closes
    if (!triggerState.isOpen) {
      selectionManager.setFocusedKey(null);
    }
  }, [triggerState.isOpen, selectionManager]);

  let commitCustomValue = () => {
    let shouldClose = false;
    lastSelectedKey.current = null;
    setSelectedKey(null); // If previous key was already null, need to manually call onSelectionChange since it won't be triggered by a setSelectedKey call
    // This allows the application to control whether or not to close the menu on custom value commit

    if (selectedKey === null && props.onSelectionChange) {
      props.onSelectionChange(null);
    } // Should close menu ourselves if component open state or selected key is uncontrolled and therefore won't be closed by a user defined event handler


    shouldClose = props.isOpen == null || props.selectedKey === undefined; // Close if no other event will be fired. Otherwise, allow the
    // application to control this based on that event.

    if (shouldClose) {
      triggerState.close();
    }
  };

  let commit = () => {
    if (triggerState.isOpen && selectionManager.focusedKey != null) {
      // Reset inputValue and close menu here if the selected key is already the focused key. Otherwise
      // fire onSelectionChange to allow the application to control the closing.
      if (selectedKey === selectionManager.focusedKey) {
        resetInputValue();
        triggerState.close();
      } else {
        setSelectedKey(selectionManager.focusedKey);
      }
    } else if (allowsCustomValue) {
      commitCustomValue();
    }
  };

  let setFocused = isFocused => {
    if (isFocused) {
      if (menuTrigger === 'focus') {
        open();
      }
    } else if (shouldCloseOnBlur) {
      var _collection$getItem$t2, _collection$getItem2;

      let itemText = (_collection$getItem$t2 = (_collection$getItem2 = collection.getItem(selectedKey)) == null ? void 0 : _collection$getItem2.textValue) != null ? _collection$getItem$t2 : '';

      if (allowsCustomValue && inputValue !== itemText) {
        commitCustomValue();
      } else {
        resetInputValue(); // Close menu if blurring away from the combobox
        // Specifically handles case where user clicks away from the field

        triggerState.close();
      }
    }

    setFocusedState(isFocused);
  };

  return _babelRuntimeHelpersExtends({}, triggerState, {
    toggle,
    open,
    selectionManager,
    selectedKey,
    setSelectedKey,
    disabledKeys,
    isFocused,
    setFocused,
    selectedItem,
    collection: filteredCollection,
    inputValue,
    setInputValue,
    commit
  });
}

exports.useComboBoxState = useComboBoxState;

function $a21047c5b4305a7d5e80cc48828d4cd$var$filterCollection(collection, inputValue, filter) {
  return new ListCollection($a21047c5b4305a7d5e80cc48828d4cd$var$filterNodes(collection, inputValue, filter));
}

function $a21047c5b4305a7d5e80cc48828d4cd$var$filterNodes(nodes, inputValue, filter) {
  let filteredNode = [];

  for (let node of nodes) {
    if (node.type === 'section' && node.hasChildNodes) {
      let filtered = $a21047c5b4305a7d5e80cc48828d4cd$var$filterNodes(node.childNodes, inputValue, filter);

      if ([...filtered].length > 0) {
        filteredNode.push(_babelRuntimeHelpersExtends({}, node, {
          childNodes: filtered
        }));
      }
    } else if (node.type !== 'section' && filter(node.textValue, inputValue)) {
      filteredNode.push(node);
    }
  }

  return filteredNode;
}
//# sourceMappingURL=main.js.map
