"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disableTextSelection = disableTextSelection;
exports.restoreTextSelection = restoreTextSelection;

var _utils = require("@react-aria/utils");

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
let state = 'default';
let savedUserSelect = '';

function disableTextSelection() {
  if (state === 'default') {
    savedUserSelect = document.documentElement.style.webkitUserSelect;
    document.documentElement.style.webkitUserSelect = 'none';
  }

  state = 'disabled';
}

function restoreTextSelection() {
  // If the state is already default, there's nothing to do.
  // If it is restoring, then there's no need to queue a second restore.
  if (state !== 'disabled') {
    return;
  }

  state = 'restoring'; // There appears to be a delay on iOS where selection still might occur
  // after pointer up, so wait a bit before removing user-select.

  setTimeout(() => {
    // Wait for any CSS transitions to complete so we don't recompute style
    // for the whole page in the middle of the animation and cause jank.
    (0, _utils.runAfterTransition)(() => {
      // Avoid race conditions
      if (state === 'restoring') {
        if (document.documentElement.style.webkitUserSelect === 'none') {
          document.documentElement.style.webkitUserSelect = savedUserSelect || '';
        }

        savedUserSelect = '';
        state = 'default';
      }
    });
  }, 300);
}
//# sourceMappingURL=textSelection.js.map