"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckbox = useCheckbox;
var _utils = require("@react-aria/utils");
var _toggle = require("@react-native-aria/toggle");
/**
 * Provides the behavior and accessibility implementation for a checkbox component.
 * Checkboxes allow users to select multiple items from a list of individual items, or
 * to mark one individual item as selected.
 * @param props - Props for the checkbox.
 * @param state - State for the checkbox, as returned by `useToggleState`.
 * @param inputRef - A ref for the HTML input element.
 */
function useCheckbox(props, state, inputRef) {
  let {
    inputProps
  } = (0, _toggle.useToggle)(props, state, inputRef);
  let {
    isSelected
  } = state;
  let {
    isIndeterminate
  } = props;
  return {
    inputProps: (0, _utils.mergeProps)(inputProps, {
      'checked': isSelected,
      'role': 'checkbox',
      'aria-checked': isIndeterminate ? 'mixed' : isSelected,
      'aria-disabled': props.isDisabled
    })
  };
}
//# sourceMappingURL=useCheckbox.js.map