"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToggleButton = useToggleButton;

var _useButton = require("./useButton");

var _utils = require("@react-aria/utils");

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/**
 * Provides the behavior and accessibility implementation for a toggle button component.
 * ToggleButtons allow users to toggle a selection on or off, for example switching between two states or modes.
 */
function useToggleButton(props, state) {
  /* eslint-enable no-redeclare */
  const {
    isSelected
  } = state;
  const {
    isPressed,
    buttonProps
  } = (0, _useButton.useButton)({ ...props,
    onPress: (0, _utils.chain)(state.toggle, props.onPress)
  });
  return {
    isPressed,
    buttonProps: (0, _utils.mergeProps)(buttonProps, {
      'aria-pressed': isSelected
    })
  };
}
//# sourceMappingURL=useToggleButton.web.js.map