"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getFormat;
var _csv = _interopRequireDefault(require("./csv"));
var _lingui = _interopRequireDefault(require("./lingui"));
var _minimal = _interopRequireDefault(require("./minimal"));
var _po = _interopRequireDefault(require("./po"));
var _poGettext = _interopRequireDefault(require("./po-gettext"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const formats = {
  lingui: _lingui.default,
  minimal: _minimal.default,
  po: _po.default,
  csv: _csv.default,
  "po-gettext": _poGettext.default
};

/**
 * @internal
 */

function getFormat(name) {
  const format = formats[name];
  if (!format) {
    throw new Error(`Unknown format "${name}". Use one of following: ${Object.keys(formats).join(", ")}`);
  }
  return format;
}