"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _core = require("@babel/core");
var _babelPluginExtractMessages = _interopRequireDefault(require("@lingui/babel-plugin-extract-messages"));
var _detect = require("../detect");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const typescriptRe = /(^.?|\.[^d]|[^.]d|[^.][^d])\.tsx?$/i;
const extractor = {
  match(filename) {
    return typescriptRe.test(filename);
  },
  extract(filename, localeDir, options = {}) {
    const ts = require("typescript");
    const content = _fs.default.readFileSync(filename, "utf8");
    const isTsx = filename.endsWith(".tsx");
    // pass jsx to babel untouched
    const jsx = isTsx ? ts.JsxEmit.Preserve : ts.JsxEmit.None;
    const stripped = ts.transpileModule(content, {
      compilerOptions: {
        filename,
        jsx,
        module: ts.ModuleKind.ESNext,
        target: ts.ScriptTarget.ES2016,
        // use ES2015 or ES2016 to preserve tagged template literal
        allowSyntheticDefaultImports: true,
        moduleResolution: ts.ModuleResolutionKind.NodeJs
      }
    });
    const frameworkOptions = {};
    if (options.projectType === _detect.projectType.CRA) {
      frameworkOptions.presets = ["react-app"];
    }
    const {
      babelOptions = {},
      configPath
    } = options;
    const plugins = ["macros", [_babelPluginExtractMessages.default, {
      localeDir,
      configPath
    }], ...(babelOptions.plugins || [])];
    if (isTsx) {
      plugins.unshift(require.resolve("@babel/plugin-syntax-jsx"));
    }
    (0, _core.transform)(stripped.outputText, {
      ...babelOptions,
      ...frameworkOptions,
      filename,
      plugins
    });
  }
};
var _default = extractor;
exports.default = _default;