"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compile = compile;
exports.createCompiledCatalog = createCompiledCatalog;
var t = _interopRequireWildcard(require("@babel/types"));
var _generator = _interopRequireDefault(require("@babel/generator"));
var _compile = require("@lingui/core/compile");
var _pseudoLocalize = _interopRequireDefault(require("./pseudoLocalize"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function createCompiledCatalog(locale, messages, options) {
  const {
    strict = false,
    namespace = "cjs",
    pseudoLocale,
    compilerBabelOptions = {}
  } = options;
  const shouldPseudolocalize = locale === pseudoLocale;
  const compiledMessages = Object.keys(messages).reduce((obj, key) => {
    const value = messages[key];

    // If the current ID's value is a context object, create a nested
    // expression, and assign the current ID to that expression
    if (typeof value === "object") {
      obj[key] = Object.keys(value).reduce((obj, contextKey) => {
        obj[contextKey] = compile(value[contextKey], shouldPseudolocalize);
        return obj;
      }, {});
      return obj;
    }

    // Don't use `key` as a fallback translation in strict mode.
    const translation = messages[key] || (!strict ? key : "");
    obj[key] = compile(translation, shouldPseudolocalize);
    return obj;
  }, {});
  const ast = buildExportStatement(
  //build JSON.parse(<compiledMessages>) statement
  t.callExpression(t.memberExpression(t.identifier("JSON"), t.identifier("parse")), [t.stringLiteral(JSON.stringify(compiledMessages))]), namespace);
  const code = (0, _generator.default)(ast, {
    minified: true,
    jsescOption: {
      minimal: true
    },
    ...compilerBabelOptions
  }).code;
  return "/*eslint-disable*/" + code;
}
function buildExportStatement(expression, namespace) {
  if (namespace === "es" || namespace === "ts") {
    // export const messages = { message: "Translation" }
    return t.exportNamedDeclaration(t.variableDeclaration("const", [t.variableDeclarator(t.identifier("messages"), expression)]));
  } else {
    let exportExpression = null;
    const matches = namespace.match(/^(window|global)\.([^.\s]+)$/);
    if (namespace === "cjs") {
      // module.exports.messages = { message: "Translation" }
      exportExpression = t.memberExpression(t.identifier("module"), t.identifier("exports"));
    } else if (matches) {
      // window.i18nMessages = { messages: { message: "Translation" }}
      exportExpression = t.memberExpression(t.identifier(matches[1]), t.identifier(matches[2]));
    } else {
      throw new Error(`Invalid namespace param: "${namespace}"`);
    }
    return t.expressionStatement(t.assignmentExpression("=", exportExpression, t.objectExpression([t.objectProperty(t.identifier("messages"), expression)])));
  }
}

/**
 * Compile string message into AST tree. Message format is parsed/compiled into
 * JS arrays, which are handled in client.
 */
function compile(message, shouldPseudolocalize = false) {
  return (0, _compile.compileMessage)(message, value => shouldPseudolocalize ? (0, _pseudoLocalize.default)(value) : value);
}