function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React, { memo, forwardRef } from 'react';
import Box from '../../primitives/Box';
import { usePropsResolution } from '../../../hooks/useThemeProps';
import { Popper } from '../Popper';
import { AccessibilityInfo, ScrollView } from 'react-native';
import { useControllableState } from '../../../hooks';
import { useMenuTrigger, useMenu, useMenuTypeahead } from './useMenu';
import Backdrop from '../Backdrop';
import { PresenceTransition } from '../Transitions';
import { FocusScope } from '@react-native-aria/focus';
import { MenuContext } from './MenuContext';
import { Overlay } from '../../primitives/Overlay';
import { useHasResponsiveProps } from '../../../hooks/useHasResponsiveProps';

const Menu = ({
  trigger,
  closeOnSelect = true,
  children,
  onOpen,
  onClose,
  isOpen: isOpenProp,
  defaultIsOpen,
  placement = 'bottom left',
  ...props
}, ref) => {
  const triggerRef = React.useRef(null);
  const [isOpen, setIsOpen] = useControllableState({
    value: isOpenProp,
    defaultValue: defaultIsOpen,
    onChange: value => {
      value ? onOpen && onOpen() : onClose && onClose();
    }
  });
  const {
    _overlay,
    _presenceTransition,
    _backdrop,
    useRNModal,
    ...resolvedProps
  } = usePropsResolution('Menu', props);
  const handleOpen = React.useCallback(() => {
    setIsOpen(true);
  }, [setIsOpen]);
  const handleClose = React.useCallback(() => {
    setIsOpen(false);
  }, [setIsOpen]);
  const triggerProps = useMenuTrigger({
    handleOpen,
    isOpen
  });

  const updatedTrigger = () => {
    return trigger({ ...triggerProps,
      ref: triggerRef,
      onPress: handleOpen
    }, {
      open: isOpen
    });
  };

  React.useEffect(() => {
    if (isOpen) {
      AccessibilityInfo.announceForAccessibility('Popup window');
    }
  }, [isOpen]); //TODO: refactor for responsive prop

  if (useHasResponsiveProps(resolvedProps)) {
    return null;
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, updatedTrigger(), /*#__PURE__*/React.createElement(Overlay, _extends({
    isOpen: isOpen,
    onRequestClose: handleClose,
    useRNModalOnAndroid: true,
    useRNModal: useRNModal
  }, _overlay), /*#__PURE__*/React.createElement(PresenceTransition, _extends({
    visible: isOpen
  }, _presenceTransition), /*#__PURE__*/React.createElement(Popper, _extends({
    triggerRef: triggerRef,
    onClose: handleClose,
    placement: placement
  }, resolvedProps), /*#__PURE__*/React.createElement(Backdrop, _extends({
    onPress: handleClose
  }, _backdrop)), /*#__PURE__*/React.createElement(Popper.Content, {
    isOpen: isOpen
  }, /*#__PURE__*/React.createElement(MenuContext.Provider, {
    value: {
      closeOnSelect,
      onClose: handleClose
    }
  }, /*#__PURE__*/React.createElement(FocusScope, {
    contain: true,
    restoreFocus: true,
    autoFocus: true
  }, /*#__PURE__*/React.createElement(MenuContent, _extends({
    menuRef: ref
  }, resolvedProps), children))))))));
};

const MenuContent = ({
  menuRef,
  children,
  ...props
}) => {
  const menuProps = useMenu();
  const typeaheadProps = useMenuTypeahead(menuProps);
  return /*#__PURE__*/React.createElement(Box, _extends({}, props, menuProps, typeaheadProps, {
    ref: menuRef
  }), /*#__PURE__*/React.createElement(ScrollView, null, children));
};

export default /*#__PURE__*/memo( /*#__PURE__*/forwardRef(Menu));
//# sourceMappingURL=Menu.js.map