"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tooltip = void 0;

var _overlays = require("@react-native-aria/overlays");

var _react = _interopRequireDefault(require("react"));

var _hooks = require("../../../hooks");

var _Popper = require("../Popper");

var _utils = require("../../../utils");

var _Transitions = require("../Transitions");

var _reactNative = require("react-native");

var _Box = _interopRequireDefault(require("../../primitives/Box"));

var _utils2 = require("@react-native-aria/utils");

var _useHasResponsiveProps = require("../../../hooks/useHasResponsiveProps");

var _lodash = _interopRequireDefault(require("lodash.uniqueid"));

var _ResponsiveQueryProvider = require("../../../utils/useResponsiveQuery/ResponsiveQueryProvider");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const Tooltip = ({
  label,
  children,
  onClose,
  onOpen,
  defaultIsOpen,
  placement,
  openDelay = 0,
  closeDelay = 0,
  closeOnClick = true,
  offset,
  isDisabled,
  hasArrow,
  arrowSize = 12,
  isOpen: isOpenProp,
  ...props
}) => {
  var _ref, _ref2, _props$backgroundColo;

  if (hasArrow && offset === undefined) {
    offset = 0;
  } else {
    offset = 6;
  }

  const resolvedProps = (0, _hooks.usePropsResolution)('Tooltip', props);
  const [isOpen, setIsOpen] = (0, _hooks.useControllableState)({
    value: isOpenProp,
    defaultValue: defaultIsOpen,
    onChange: value => {
      value ? onOpen && onOpen() : onClose && onClose();
    }
  });
  const arrowBg = (_ref = (_ref2 = (_props$backgroundColo = props.backgroundColor) !== null && _props$backgroundColo !== void 0 ? _props$backgroundColo : props.bgColor) !== null && _ref2 !== void 0 ? _ref2 : props.bg) !== null && _ref !== void 0 ? _ref : resolvedProps.bg;

  const targetRef = _react.default.useRef(null);

  const enterTimeout = _react.default.useRef();

  const exitTimeout = _react.default.useRef(); // const tooltipID = '';
  // const tooltipID = useId();


  let tooltipID = (0, _lodash.default)(); // let id = uniqueId();

  const responsiveQueryContext = _react.default.useContext(_ResponsiveQueryProvider.ResponsiveQueryContext);

  const disableCSSMediaQueries = responsiveQueryContext.disableCSSMediaQueries;

  if (!disableCSSMediaQueries) {
    // This if statement technically breaks the rules of hooks, but is safe
    // because the condition never changes after mounting.
    // eslint-disable-next-line react-hooks/rules-of-hooks
    tooltipID = (0, _utils2.useId)();
  }

  const openWithDelay = _react.default.useCallback(() => {
    if (!isDisabled) {
      enterTimeout.current = setTimeout(() => setIsOpen(true), openDelay);
    }
  }, [isDisabled, setIsOpen, openDelay]);

  const closeWithDelay = _react.default.useCallback(() => {
    if (enterTimeout.current) {
      clearTimeout(enterTimeout.current);
    }

    exitTimeout.current = setTimeout(() => setIsOpen(false), closeDelay);
  }, [closeDelay, setIsOpen]);

  _react.default.useEffect(() => () => {
    clearTimeout(enterTimeout.current);
    clearTimeout(exitTimeout.current);
  }, []);

  let newChildren = children;

  if (typeof children === 'string') {
    newChildren = /*#__PURE__*/_react.default.createElement(_Box.default, null, children);
  }

  newChildren = /*#__PURE__*/_react.default.cloneElement(newChildren, {
    'onPress': (0, _utils.composeEventHandlers)(newChildren.props.onPress, () => {
      if (closeOnClick) {
        closeWithDelay();
      }
    }),
    'onFocus': (0, _utils.composeEventHandlers)(newChildren.props.onFocus, openWithDelay),
    'onBlur': (0, _utils.composeEventHandlers)(newChildren.props.onBlur, closeWithDelay),
    'onMouseEnter': (0, _utils.composeEventHandlers)(newChildren.props.onMouseEnter, openWithDelay),
    'onMouseLeave': (0, _utils.composeEventHandlers)(newChildren.props.onMouseLeave, closeWithDelay),
    'ref': (0, _utils.mergeRefs)([newChildren.ref, targetRef]),
    'aria-describedby': isOpen ? tooltipID : undefined
  });
  (0, _hooks.useKeyboardDismissable)({
    enabled: isOpen,
    callback: () => setIsOpen(false)
  }); //TODO: refactor for responsive prop

  if ((0, _useHasResponsiveProps.useHasResponsiveProps)(props)) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, newChildren, isOpen && /*#__PURE__*/_react.default.createElement(_overlays.OverlayContainer, null, /*#__PURE__*/_react.default.createElement(_Transitions.PresenceTransition, {
    initial: {
      opacity: 0
    },
    animate: {
      opacity: 1,
      transition: {
        duration: 150
      }
    },
    exit: {
      opacity: 0,
      transition: {
        duration: 100
      }
    },
    visible: isOpen,
    style: _reactNative.StyleSheet.absoluteFill
  }, /*#__PURE__*/_react.default.createElement(_Popper.Popper, {
    triggerRef: targetRef,
    onClose: () => setIsOpen(false),
    placement: placement,
    offset: offset
  }, /*#__PURE__*/_react.default.createElement(_Popper.Popper.Content, {
    isOpen: isOpen
  }, hasArrow && /*#__PURE__*/_react.default.createElement(_Popper.Popper.Arrow, {
    borderColor: "transparent",
    backgroundColor: arrowBg,
    height: arrowSize,
    width: arrowSize
  }), /*#__PURE__*/_react.default.createElement(_Box.default, _extends({}, resolvedProps, {
    //@ts-ignore
    accessibilityRole: _reactNative.Platform.OS === 'web' ? 'tooltip' : undefined,
    nativeID: tooltipID
  }), label))))));
};

exports.Tooltip = Tooltip;
//# sourceMappingURL=Tooltip.js.map