"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _Box = _interopRequireDefault(require("../../primitives/Box"));

var _useThemeProps = require("../../../hooks/useThemeProps");

var _Popper = require("../Popper");

var _reactNative = require("react-native");

var _hooks = require("../../../hooks");

var _useMenu = require("./useMenu");

var _Backdrop = _interopRequireDefault(require("../Backdrop"));

var _Transitions = require("../Transitions");

var _focus = require("@react-native-aria/focus");

var _MenuContext = require("./MenuContext");

var _Overlay = require("../../primitives/Overlay");

var _useHasResponsiveProps = require("../../../hooks/useHasResponsiveProps");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const Menu = ({
  trigger,
  closeOnSelect = true,
  children,
  onOpen,
  onClose,
  isOpen: isOpenProp,
  defaultIsOpen,
  placement = 'bottom left',
  ...props
}, ref) => {
  const triggerRef = _react.default.useRef(null);

  const [isOpen, setIsOpen] = (0, _hooks.useControllableState)({
    value: isOpenProp,
    defaultValue: defaultIsOpen,
    onChange: value => {
      value ? onOpen && onOpen() : onClose && onClose();
    }
  });
  const {
    _overlay,
    _presenceTransition,
    _backdrop,
    useRNModal,
    ...resolvedProps
  } = (0, _useThemeProps.usePropsResolution)('Menu', props);

  const handleOpen = _react.default.useCallback(() => {
    setIsOpen(true);
  }, [setIsOpen]);

  const handleClose = _react.default.useCallback(() => {
    setIsOpen(false);
  }, [setIsOpen]);

  const triggerProps = (0, _useMenu.useMenuTrigger)({
    handleOpen,
    isOpen
  });

  const updatedTrigger = () => {
    return trigger({ ...triggerProps,
      ref: triggerRef,
      onPress: handleOpen
    }, {
      open: isOpen
    });
  };

  _react.default.useEffect(() => {
    if (isOpen) {
      _reactNative.AccessibilityInfo.announceForAccessibility('Popup window');
    }
  }, [isOpen]); //TODO: refactor for responsive prop


  if ((0, _useHasResponsiveProps.useHasResponsiveProps)(resolvedProps)) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, updatedTrigger(), /*#__PURE__*/_react.default.createElement(_Overlay.Overlay, _extends({
    isOpen: isOpen,
    onRequestClose: handleClose,
    useRNModalOnAndroid: true,
    useRNModal: useRNModal
  }, _overlay), /*#__PURE__*/_react.default.createElement(_Transitions.PresenceTransition, _extends({
    visible: isOpen
  }, _presenceTransition), /*#__PURE__*/_react.default.createElement(_Popper.Popper, _extends({
    triggerRef: triggerRef,
    onClose: handleClose,
    placement: placement
  }, resolvedProps), /*#__PURE__*/_react.default.createElement(_Backdrop.default, _extends({
    onPress: handleClose
  }, _backdrop)), /*#__PURE__*/_react.default.createElement(_Popper.Popper.Content, {
    isOpen: isOpen
  }, /*#__PURE__*/_react.default.createElement(_MenuContext.MenuContext.Provider, {
    value: {
      closeOnSelect,
      onClose: handleClose
    }
  }, /*#__PURE__*/_react.default.createElement(_focus.FocusScope, {
    contain: true,
    restoreFocus: true,
    autoFocus: true
  }, /*#__PURE__*/_react.default.createElement(MenuContent, _extends({
    menuRef: ref
  }, resolvedProps), children))))))));
};

const MenuContent = ({
  menuRef,
  children,
  ...props
}) => {
  const menuProps = (0, _useMenu.useMenu)();
  const typeaheadProps = (0, _useMenu.useMenuTypeahead)(menuProps);
  return /*#__PURE__*/_react.default.createElement(_Box.default, _extends({}, props, menuProps, typeaheadProps, {
    ref: menuRef
  }), /*#__PURE__*/_react.default.createElement(_reactNative.ScrollView, null, children));
};

var _default = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(Menu));

exports.default = _default;
//# sourceMappingURL=Menu.js.map