"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.SunnahTimes = exports.MidnightMethod = void 0;

var _DateUtils = require("./DateUtils");

var _PrayerTimes = _interopRequireDefault(require("./PrayerTimes"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var MidnightMethod;
exports.MidnightMethod = MidnightMethod;

(function (MidnightMethod) {
  MidnightMethod["SunsetToSunrise"] = "SunsetToSunrise";
  MidnightMethod["SunsetToFajr"] = "SunsetToFajr";
})(MidnightMethod || (exports.MidnightMethod = MidnightMethod = {}));

var SunnahTimes = /*#__PURE__*/_createClass(
/** night duration in milliseconds */
function SunnahTimes(prayerTimes, midnightMethod) {
  _classCallCheck(this, SunnahTimes);

  var date = prayerTimes.date;
  var nextDay = (0, _DateUtils.dateByAddingDays)(date, 1);
  var nextDayPrayerTimes = new _PrayerTimes["default"](prayerTimes.coordinates, nextDay, prayerTimes.calculationParameters);
  var dawnTime;

  switch (midnightMethod) {
    case MidnightMethod.SunsetToFajr:
      dawnTime = nextDayPrayerTimes.fajr.getTime();
      break;

    case MidnightMethod.SunsetToSunrise:
    default:
      dawnTime = nextDayPrayerTimes.sunrise.getTime();
      break;
  }

  this.nightDuration = dawnTime - prayerTimes.sunset.getTime();
  var nightDurationSecs = this.nightDuration / 1000.0;
  this.firstThirdOfTheNight = (0, _DateUtils.roundedMinute)((0, _DateUtils.dateByAddingSeconds)(prayerTimes.sunset, nightDurationSecs * (1 / 3)));
  this.middleOfTheNight = (0, _DateUtils.roundedMinute)((0, _DateUtils.dateByAddingSeconds)(prayerTimes.sunset, nightDurationSecs / 2));
  this.lastThirdOfTheNight = (0, _DateUtils.roundedMinute)((0, _DateUtils.dateByAddingSeconds)(prayerTimes.sunset, nightDurationSecs * (2 / 3)));
});

exports.SunnahTimes = SunnahTimes;
var _default = SunnahTimes;
exports["default"] = _default;
//# sourceMappingURL=SunnahTimes.js.map