export interface ResolveFunction<T> {
    (value: T): void;
}
export interface RejectFunction {
    (reason: Error): void;
}
export interface CallbackFunction<T> {
    (error?: Error, value?: T): void;
}
export interface Resolvable<T> {
    resolve: ResolveFunction<T>;
    reject: RejectFunction;
}
export interface Tagged<T = string> {
    tag?: T;
}
export interface Deferred<T, TT = string> extends Promise<T>, Resolvable<T>, Tagged<TT> {
    callback: CallbackFunction<T>;
    promise: Promise<T>;
}
export declare function defer<T, TT = string>(timeout?: number | Number, tag?: TT, keepalive?: boolean): Deferred<T, TT>;
export declare function sleep(ms: number | Number): Promise<void>;
export interface Callable {
    (...args: any[]): void;
}
export interface FutureCallable<T> {
    (...args: any[]): Promise<T>;
}
export declare function promise<T>(func: Callable, ...args: any[]): Promise<T>;
export declare function promisify<T>(func: Callable): FutureCallable<T>;
interface CallableFuture<T> {
    (): T | Promise<T>;
}
declare type Future<T> = PromiseLike<T> | CallableFuture<T>;
export declare function timeout<T>(future: Future<T>, timeout: number | Number, keepalive?: boolean): Promise<T>;
declare const Default: Readonly<{
    defer: typeof defer;
    sleep: typeof sleep;
    promise: typeof promise;
    promisify: typeof promisify;
    timeout: typeof timeout;
}>;
export default Default;
