"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToggle = useToggle;

var _utils = require("@react-aria/utils");

var _interactions = require("@react-native-aria/interactions");

var _utils2 = require("@react-native-aria/utils");

/**
 * Handles interactions for toggle elements, e.g. Checkboxes and Switches.
 */
function useToggle(props, state, _ref) {
  let {
    isDisabled = false,
    isRequired,
    isReadOnly,
    value,
    name // validationState = 'valid', // No support for Invalid in RN

  } = props;

  let onPress = () => {
    state.setSelected(!state.isSelected);
  };

  let hasChildren = props.children != null;
  const label = (0, _utils2.getLabel)(props);

  if (!hasChildren && !label) {
    console.warn('If you do not provide children, you must specify an aria-label for accessibility');
  } // This handles focusing the input on pointer down, which Safari does not do by default.


  let {
    pressProps
  } = (0, _interactions.usePress)({
    isDisabled,
    onPress
  });
  return {
    inputProps: (0, _utils.mergeProps)(props, {
      'disabled': isDisabled,
      'required': isRequired,
      'readOnly': isReadOnly,
      value,
      name,
      ...pressProps,
      'aria-label': label,
      'aria-disabled': isDisabled
    })
  };
}
//# sourceMappingURL=useToggle.js.map