"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTab = useTab;

var _interactions = require("@react-native-aria/interactions");

var _selection = require("@react-aria/selection");

var _utils = require("@react-native-aria/utils");

const tabsIds = new WeakMap();

function useTab(props, state, ref) {
  let {
    item,
    isDisabled: propsDisabled
  } = props;
  let {
    key
  } = item;
  let {
    selectionManager: manager,
    selectedKey
  } = state;
  let isSelected = key === selectedKey;
  let {
    itemProps
  } = (0, _selection.useSelectableItem)({
    selectionManager: manager,
    key,
    ref
  });
  let isDisabled = propsDisabled || state.disabledKeys.has(key);
  let {
    pressProps
  } = (0, _interactions.usePress)({ ...itemProps,
    isDisabled
  });
  let tabId = generateId(state, key, 'tab');
  let tabPanelId = generateId(state, key, 'tabpanel');
  let {
    tabIndex
  } = pressProps; // selected tab should have tabIndex=0, when it initializes

  if (isSelected && !isDisabled) {
    tabIndex = 0;
  } // Putting this as a last resort, after several hours of debugging.
  // Why?
  // tabListProps adds onMouseDown with preventDefault in useSelectableCollection.ts (React Aria) and react-native-web uses onClick for onPress.
  // This results in tab button not getting focused when clicked
  // See this example - https://codesandbox.io/s/issue-i-know-but-dont-know-why-1-ydyw5?file=/src/App.js


  const onMouseDown = e => e.stopPropagation();

  const tabPropsTemp = { ...pressProps,
    onMouseDown,
    'id': tabId,
    'aria-selected': isSelected,
    'aria-disabled': isDisabled || undefined,
    'aria-controls': isSelected ? tabPanelId : undefined,
    'tabIndex': isDisabled ? undefined : tabIndex,
    'role': 'tab'
  };
  const tabProps = (0, _utils.useMapDomPropsToRN)(tabPropsTemp, ref);
  return {
    tabProps
  };
}

function generateId(state, key, role) {
  if (typeof key === 'string') {
    key = key.replace(/\s+/g, '');
  }

  let baseId = tabsIds.get(state);
  return `${baseId}-${role}-${key}`;
}
//# sourceMappingURL=useTab.web.js.map