import { AriaSliderThumbProps } from '@react-types/slider';
import { HTMLAttributes, InputHTMLAttributes, LabelHTMLAttributes, RefObject } from 'react';
import { SliderState } from '@react-stately/slider';
interface SliderThumbAria {
    /** Props for the root thumb element; handles the dragging motion. */
    thumbProps: HTMLAttributes<HTMLElement>;
    /** Props for the visually hidden range input element. */
    inputProps: InputHTMLAttributes<HTMLInputElement>;
    /** Props for the label element for this thumb (optional). */
    labelProps: LabelHTMLAttributes<HTMLLabelElement>;
}
interface SliderThumbOptions extends AriaSliderThumbProps {
    /** A ref to the track element. */
    trackLayout: any;
    /** A ref to the thumb input element. */
    inputRef: RefObject<HTMLInputElement>;
}
/**
 * Provides behavior and accessibility for a thumb of a slider component.
 *
 * @param opts Options for this Slider thumb.
 * @param state Slider state, created via `useSliderState`.
 */
export declare function useSliderThumb(opts: SliderThumbOptions, state: SliderState, isReversed?: boolean): SliderThumbAria;
export {};
