import { getLabel } from '@react-native-aria/utils';

/**
 * Provides the behavior and accessibility implementation for a radio group component.
 * Radio groups allow users to select a single item from a list of mutually exclusive options.
 * @param props - Props for the radio group.
 * @param state - State for the radio group, as returned by `useRadioGroupState`.
 */
export function useRadioGroup(props, _state) {
  let {
    isDisabled
  } = props;
  return {
    radioGroupProps: {
      'aria-label': getLabel(props),
      'role': 'radiogroup',
      'aria-disabled': isDisabled
    },
    labelProps: {}
  };
}
//# sourceMappingURL=useRadioGroup.js.map