import { HTMLAttributes, RefObject } from 'react';
import { PlacementAxis, PositionProps } from '@react-types/overlays';
interface AriaPositionProps extends PositionProps {
    /**
     * Element that that serves as the positioning boundary.
     * @default document.body
     */
    boundaryElement?: HTMLElement;
    /**
     * The ref for the element which the overlay positions itself with respect to.
     */
    targetRef: RefObject<HTMLElement>;
    /**
     * The ref for the overlay element.
     */
    overlayRef: RefObject<HTMLElement>;
    /**
     * A ref for the scrollable region within the overlay.
     * @default overlayRef
     */
    scrollRef?: RefObject<HTMLElement>;
    /**
     * Whether the overlay should update its position automatically.
     * @default true
     */
    shouldUpdatePosition?: boolean;
    /** Handler that is called when the overlay should close. */
    onClose?: () => void;
    /** Determines whether the overlay should overlap with the trigger */
    shouldOverlapWithTrigger?: boolean;
}
interface PositionAria {
    /** Props for the overlay container element. */
    overlayProps: HTMLAttributes<Element>;
    /** Props for the overlay tip arrow if any. */
    arrowProps: HTMLAttributes<Element>;
    /** Placement of the overlay with respect to the overlay trigger. */
    placement: PlacementAxis;
    /** Updates the position of the overlay. */
    updatePosition(): void;
}
/**
 * Handles positioning overlays like popovers and menus relative to a trigger
 * element, and updating the position when the window resizes.
 */
export declare function useOverlayPosition(props: AriaPositionProps): PositionAria;
export {};
//# sourceMappingURL=useOverlayPosition.d.ts.map