import { HTMLAttributes, RefObject } from 'react';
import { OverlayTriggerState } from '@react-stately/overlays';
interface OverlayTriggerProps {
    /** Type of overlay that is opened by the trigger. */
    type: 'dialog' | 'menu' | 'listbox' | 'tree' | 'grid';
}
interface OverlayTriggerAria {
    /** Props for the trigger element. */
    triggerProps: any;
    /** Props for the overlay container element. */
    overlayProps: HTMLAttributes<HTMLElement>;
}
/**
 * Handles the behavior and accessibility for an overlay trigger, e.g. a button
 * that opens a popover, menu, or other overlay that is positioned relative to the trigger.
 */
export declare function useOverlayTrigger(_props: OverlayTriggerProps, state: OverlayTriggerState, _ref: RefObject<HTMLElement>): OverlayTriggerAria;
export {};
//# sourceMappingURL=useOverlayTrigger.d.ts.map