import type { PlacementAxis } from '@react-types/overlays';
import { RefObject } from 'react';
import type { PositionProps } from '@react-types/overlays';
interface AriaPositionProps extends PositionProps {
    /**
     * Element that that serves as the positioning boundary.
     * @default document.body
     */
    boundaryElement?: any;
    /**
     * The ref for the element which the overlay positions itself with respect to.
     */
    targetRef: RefObject<any>;
    /**
     * The ref for the overlay element.
     */
    overlayRef: RefObject<any>;
    /**
     * A ref for the scrollable region within the overlay.
     * @default overlayRef
     */
    scrollRef?: RefObject<any>;
    /**
     * Whether the overlay should update its position automatically.
     * @default true
     */
    shouldUpdatePosition?: boolean;
    /** Handler that is called when the overlay should close. */
    onClose?: () => void;
    /** Determines whether the overlay should overlap with the trigger */
    shouldOverlapWithTrigger?: boolean;
}
export declare function useOverlayPosition(props: AriaPositionProps): {
    rendered: boolean;
    overlayProps: {
        style: {
            top?: number;
            left?: number;
            bottom?: number;
            right?: number;
        };
    };
    placement: PlacementAxis;
    arrowProps: {
        style: {
            left: number;
            top: number;
        };
    };
    updatePosition: () => Promise<void>;
};
interface Position {
    top?: number;
    left?: number;
    bottom?: number;
    right?: number;
}
export interface PositionResult {
    position?: Position;
    arrowOffsetLeft?: number;
    arrowOffsetTop?: number;
    maxHeight?: number;
    placement: PlacementAxis | undefined;
}
interface Position {
    top?: number;
    left?: number;
    bottom?: number;
    right?: number;
}
export {};
//# sourceMappingURL=useOverlayPosition.d.ts.map