export const listIds = new WeakMap();

function normalizeKey(key) {
  if (typeof key === 'string') {
    return key.replace(/\s*/g, '');
  }

  return '' + key;
}

export function getItemId(state, itemKey) {
  let listId = listIds.get(state);

  if (!listId) {
    throw new Error('Unknown list');
  }

  return `${listId}-option-${normalizeKey(itemKey)}`;
}
//# sourceMappingURL=utils.js.map