"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getItemId = getItemId;
exports.listIds = void 0;
const listIds = new WeakMap();
exports.listIds = listIds;

function normalizeKey(key) {
  if (typeof key === 'string') {
    return key.replace(/\s*/g, '');
  }

  return '' + key;
}

function getItemId(state, itemKey) {
  let listId = listIds.get(state);

  if (!listId) {
    throw new Error('Unknown list');
  }

  return `${listId}-option-${normalizeKey(itemKey)}`;
}
//# sourceMappingURL=utils.js.map