"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListBox = useListBox;

var _utils = require("@react-aria/utils");

var _utils2 = require("./utils");

var _label = require("@react-aria/label");

var _selection = require("@react-aria/selection");

var _utils3 = require("@react-native-aria/utils");

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/**
 * Provides the behavior and accessibility implementation for a listbox component.
 * A listbox displays a list of options and allows a user to select one or more of them.
 * @param props - Props for the listbox.
 * @param state - State for the listbox, as returned by `useListState`.
 */
function useListBox(props, state, ref) {
  let domProps = (0, _utils.filterDOMProps)(props, {
    labelable: true
  });
  let {
    listProps
  } = (0, _selection.useSelectableList)({ ...props,
    ref,
    selectionManager: state.selectionManager,
    collection: state.collection,
    disabledKeys: state.disabledKeys
  });
  let id = (0, _utils.useId)(props.id);

  _utils2.listIds.set(state, id);

  let {
    labelProps: _labelProps,
    fieldProps
  } = (0, _label.useLabel)({ ...props,
    id,
    // listbox is not an HTML input element so it
    // shouldn't be labeled by a <label> element.
    labelElementType: 'span'
  });
  const labelProps = (0, _utils3.mapDomPropsToRN)(_labelProps);

  const _listBoxProps = (0, _utils.mergeProps)(domProps, state.selectionManager.selectionMode === 'multiple' ? {
    'aria-multiselectable': 'true'
  } : {}, {
    role: 'listbox',
    ...(0, _utils.mergeProps)(fieldProps, listProps)
  });

  const listBoxProps = (0, _utils3.useMapDomPropsToRN)(_listBoxProps, ref);
  return {
    labelProps,
    listBoxProps
  };
}
//# sourceMappingURL=useListBox.web.js.map