"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHover = void 0;

var _interactions = require("@react-aria/interactions");

var _react = require("react");

var _utils = require("@react-native-aria/utils");

const useHover = (props = {}, ref) => {
  let params = (0, _interactions.useHover)(props);
  (0, _react.useEffect)(() => {
    ref && ref.current && (0, _utils.attachEventHandlersOnRef)(params.hoverProps, ref);
  }, []);
  const finalResult = { ...params,
    hoverProps: { ...params.hoverProps,
      onHoverIn: params.hoverProps.onPointerEnter,
      onHoverOut: params.hoverProps.onPointerLeave
    }
  };
  return finalResult;
};

exports.useHover = useHover;
//# sourceMappingURL=useHover.web.js.map