"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFocus = void 0;

var _react = require("react");

const useFocus = () => {
  const [isFocused, setFocused] = (0, _react.useState)(false);
  return {
    focusProps: {
      onFocus: () => setFocused(true),
      onBlur: () => setFocused(false)
    },
    isFocused
  };
};

exports.useFocus = useFocus;
//# sourceMappingURL=useFocus.js.map