import { useComboBox as useComboBoxWeb } from '@react-aria/combobox';
import { mapDomPropsToRN } from '@react-native-aria/utils';

/**
 * Provides the behavior and accessibility implementation for a combo box component.
 * A combo box combines a text input with a listbox, allowing users to filter a list of options to items matching a query.
 * @param props - Props for the combo box.
 * @param state - State for the select, as returned by `useComboBoxState`.
 */
export function useComboBox(props, state) {
  // @ts-ignore
  const params = useComboBoxWeb(props, state);
  const onKeyPress = params.inputProps.onKeyDown;
  params.inputProps.onKeyDown = undefined; // RN Web supports onKeyPress. It's same as onKeyDown
  // https://necolas.github.io/react-native-web/docs/text-input/

  params.inputProps.onKeyPress = onKeyPress; // @ts-ignore

  params.inputProps.blurOnSubmit = false;
  params.inputProps.onKeyDown = undefined;
  return {
    inputProps: mapDomPropsToRN(params.inputProps),
    buttonProps: mapDomPropsToRN(params.buttonProps),
    labelProps: mapDomPropsToRN(params.labelProps),
    listBoxProps: mapDomPropsToRN(params.listBoxProps)
  };
}
//# sourceMappingURL=useComboBox.web.js.map