"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useComboBox = useComboBox;

var _combobox = require("@react-aria/combobox");

var _utils = require("@react-native-aria/utils");

/**
 * Provides the behavior and accessibility implementation for a combo box component.
 * A combo box combines a text input with a listbox, allowing users to filter a list of options to items matching a query.
 * @param props - Props for the combo box.
 * @param state - State for the select, as returned by `useComboBoxState`.
 */
function useComboBox(props, state) {
  // @ts-ignore
  const params = (0, _combobox.useComboBox)(props, state);
  const onKeyPress = params.inputProps.onKeyDown;
  params.inputProps.onKeyDown = undefined; // RN Web supports onKeyPress. It's same as onKeyDown
  // https://necolas.github.io/react-native-web/docs/text-input/

  params.inputProps.onKeyPress = onKeyPress; // @ts-ignore

  params.inputProps.blurOnSubmit = false;
  params.inputProps.onKeyDown = undefined;
  return {
    inputProps: (0, _utils.mapDomPropsToRN)(params.inputProps),
    buttonProps: (0, _utils.mapDomPropsToRN)(params.buttonProps),
    labelProps: (0, _utils.mapDomPropsToRN)(params.labelProps),
    listBoxProps: (0, _utils.mapDomPropsToRN)(params.listBoxProps)
  };
}
//# sourceMappingURL=useComboBox.web.js.map