import { mergeProps, filterDOMProps } from '@react-aria/utils';
import { getLabel } from '@react-native-aria/utils';
/**
 * Provides the behavior and accessibility implementation for a checkbox group component.
 * Checkbox groups allow users to select multiple items from a list of options.
 * @param props - Props for the checkbox group.
 * @param state - State for the checkbox group, as returned by `useCheckboxGroupState`.
 */
export function useCheckboxGroup(props, _state) {
  let {
    isDisabled
  } = props;
  let domProps = filterDOMProps(props, {
    labelable: true
  });
  return {
    groupProps: mergeProps(domProps, {
      ' aria-disabled': isDisabled,
      'aria-label': getLabel(props)
    }),
    labelProps: {}
  };
}
//# sourceMappingURL=useCheckboxGroup.js.map