"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckboxGroup = useCheckboxGroup;
var _checkbox = require("@react-aria/checkbox");
var _utils = require("@react-native-aria/utils");
/**
 * Provides the behavior and accessibility implementation for a checkbox group component.
 * Checkbox groups allow users to select multiple items from a list of options.
 * @param props - Props for the checkbox group.
 * @param state - State for the checkbox group, as returned by `useCheckboxGroupState`.
 */
function useCheckboxGroup(props, state) {
  const params = (0, _checkbox.useCheckboxGroup)(props, state);
  return {
    labelProps: {
      ...params.labelProps,
      ...(0, _utils.mapDomPropsToRN)(params.labelProps)
    },
    groupProps: {
      ...params.groupProps,
      ...(0, _utils.mapDomPropsToRN)(params.groupProps)
    }
  };
}
//# sourceMappingURL=useCheckboxGroup.web.js.map