"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckboxGroup = useCheckboxGroup;
var _utils = require("@react-aria/utils");
var _utils2 = require("@react-native-aria/utils");
/**
 * Provides the behavior and accessibility implementation for a checkbox group component.
 * Checkbox groups allow users to select multiple items from a list of options.
 * @param props - Props for the checkbox group.
 * @param state - State for the checkbox group, as returned by `useCheckboxGroupState`.
 */
function useCheckboxGroup(props, _state) {
  let {
    isDisabled
  } = props;
  let domProps = (0, _utils.filterDOMProps)(props, {
    labelable: true
  });
  return {
    groupProps: (0, _utils.mergeProps)(domProps, {
      ' aria-disabled': isDisabled,
      'aria-label': (0, _utils2.getLabel)(props)
    }),
    labelProps: {}
  };
}
//# sourceMappingURL=useCheckboxGroup.js.map