import { usePress } from '@react-native-aria/interactions';
import { mergeProps } from '@react-aria/utils';
export function useButton(props) {
  let {
    isDisabled,
    onPress,
    onPressStart,
    onPressEnd,
    onPressChange,
    ...rest
  } = props;
  let {
    pressProps,
    isPressed
  } = usePress({
    onPressStart,
    onPressEnd,
    onPressChange,
    onPress,
    isDisabled
  });
  const mergedProps = mergeProps(pressProps, rest, {
    'aria-disabled': isDisabled,
    'role': 'button',
    'disabled': isDisabled
  });
  return {
    isPressed,
    buttonProps: mergedProps
  };
}
//# sourceMappingURL=useButton.js.map