import { Module } from './types/Module';
import { AndroidChannel, AndroidChannelGroup, NativeAndroidChannel, NativeAndroidChannelGroup } from './types/NotificationAndroid';
import { InitialNotification, Notification, Event, TriggerNotification, DisplayedNotification, NotificationSettings } from './types/Notification';
import { PowerManagerInfo } from './types/PowerManagerInfo';
import { Trigger } from './types/Trigger';
import NotifeeNativeModule, { NativeModuleConfig } from './NotifeeNativeModule';
import { IOSNotificationCategory, IOSNotificationPermissions } from './types/NotificationIOS';
export default class NotifeeApiModule extends NotifeeNativeModule implements Module {
    constructor(config: NativeModuleConfig);
    getTriggerNotificationIds: () => Promise<string[]>;
    getTriggerNotifications: () => Promise<TriggerNotification[]>;
    getDisplayedNotifications: () => Promise<DisplayedNotification[]>;
    isChannelBlocked: (channelId: string) => Promise<boolean>;
    isChannelCreated: (channelId: string) => Promise<boolean>;
    cancelAllNotifications: (notificationIds?: string[], tag?: string) => Promise<void>;
    cancelDisplayedNotifications: (notificationIds?: string[], tag?: string) => Promise<void>;
    cancelTriggerNotifications: (notificationIds?: string[]) => Promise<void>;
    cancelNotification: (notificationId: string, tag?: string) => Promise<void>;
    cancelDisplayedNotification: (notificationId: string, tag?: string) => Promise<void>;
    cancelTriggerNotification: (notificationId: string) => Promise<void>;
    createChannel: (channel: AndroidChannel) => Promise<string>;
    createChannels: (channels: AndroidChannel[]) => Promise<void>;
    createChannelGroup: (channelGroup: AndroidChannelGroup) => Promise<string>;
    createChannelGroups: (channelGroups: AndroidChannelGroup[]) => Promise<void>;
    deleteChannel: (channelId: string) => Promise<void>;
    deleteChannelGroup: (channelGroupId: string) => Promise<void>;
    displayNotification: (notification: Notification) => Promise<string>;
    openAlarmPermissionSettings: () => Promise<void>;
    createTriggerNotification: (notification: Notification, trigger: Trigger) => Promise<string>;
    getChannel: (channelId: string) => Promise<NativeAndroidChannel | null>;
    getChannels: () => Promise<NativeAndroidChannel[]>;
    getChannelGroup: (channelGroupId: string) => Promise<NativeAndroidChannelGroup | null>;
    getChannelGroups: () => Promise<NativeAndroidChannelGroup[]>;
    getInitialNotification: () => Promise<InitialNotification | null>;
    onBackgroundEvent: (observer: (event: Event) => Promise<void>) => void;
    onForegroundEvent: (observer: (event: Event) => void) => (() => void);
    openNotificationSettings: (channelId?: string) => Promise<void>;
    requestPermission: (permissions?: IOSNotificationPermissions) => Promise<NotificationSettings>;
    registerForegroundService(runner: (notification: Notification) => Promise<void>): void;
    setNotificationCategories: (categories: IOSNotificationCategory[]) => Promise<void>;
    getNotificationCategories: () => Promise<IOSNotificationCategory[]>;
    getNotificationSettings: () => Promise<NotificationSettings>;
    getBadgeCount: () => Promise<number>;
    setBadgeCount: (count: number) => Promise<void>;
    incrementBadgeCount: (incrementBy?: number) => Promise<void>;
    decrementBadgeCount: (decrementBy?: number) => Promise<void>;
    isBatteryOptimizationEnabled: () => Promise<boolean>;
    openBatteryOptimizationSettings: () => Promise<void>;
    getPowerManagerInfo: () => Promise<PowerManagerInfo>;
    openPowerManagerSettings: () => Promise<void>;
    stopForegroundService: () => Promise<void>;
    hideNotificationDrawer: () => void;
}
