import { parse } from '@messageformat/parser';

// [Tokens] -> (CTX -> String)
function processTokens(tokens, mapText) {
  if (!tokens.filter(token => token.type !== "content").length) {
    return tokens.map(token => mapText(token.value)).join("");
  }
  return tokens.map(token => {
    if (token.type === "content") {
      return mapText(token.value);

      // # in plural case
    } else if (token.type === "octothorpe") {
      return "#";

      // simple argument
    } else if (token.type === "argument") {
      return [token.arg];

      // argument with custom format (date, number)
    } else if (token.type === "function") {
      var _token$param;
      const _param = token === null || token === void 0 ? void 0 : (_token$param = token.param) === null || _token$param === void 0 ? void 0 : _token$param[0];
      if (_param) {
        return [token.arg, token.key, _param.value.trim()];
      } else {
        return [token.arg, token.key];
      }
    }
    const offset = token.pluralOffset;

    // complex argument with cases
    const formatProps = {};
    token.cases.forEach(item => {
      formatProps[item.key.replace(/^=(.)+/, "$1")] = processTokens(item.tokens, mapText);
    });
    return [token.arg, token.type, {
      offset,
      ...formatProps
    }];
  });
}

// Message -> (Params -> String)
/** @internal */
function compileMessage(message) {
  let mapText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : v => v;
  try {
    return processTokens(parse(message), mapText);
  } catch (e) {
    console.error(`${e.message} \n\nMessage: ${message}`);
    return message;
  }
}

export { compileMessage };
//# sourceMappingURL=compile.js.map
