"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.copyFixture = copyFixture;
exports.makeCatalog = exports.defaultMergeOptions = exports.defaultMakeTemplateOptions = exports.defaultMakeOptions = void 0;
exports.makeNextMessage = makeNextMessage;
exports.makePrevMessage = makePrevMessage;
var _os = _interopRequireDefault(require("os"));
var _fsExtra = _interopRequireDefault(require("fs-extra"));
var _path = _interopRequireDefault(require("path"));
var _jestMocks = require("@lingui/jest-mocks");
var _catalog = require("./api/catalog");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function copyFixture(fixtureDir) {
  const tmpDir = _fsExtra.default.mkdtempSync(_path.default.join(_os.default.tmpdir(), `lingui-test-${process.pid}`));
  if (_fsExtra.default.existsSync(fixtureDir)) {
    _fsExtra.default.copySync(fixtureDir, tmpDir);
  }
  return tmpDir;
}
const defaultMakeOptions = {
  verbose: false,
  clean: false,
  overwrite: false,
  locale: null,
  prevFormat: null,
  configPath: null,
  orderBy: "messageId"
};
exports.defaultMakeOptions = defaultMakeOptions;
const defaultMakeTemplateOptions = {
  verbose: false,
  configPath: null,
  orderBy: "messageId"
};
exports.defaultMakeTemplateOptions = defaultMakeTemplateOptions;
const defaultMergeOptions = {
  overwrite: false
};
exports.defaultMergeOptions = defaultMergeOptions;
const makeCatalog = (config = {}) => {
  return new _catalog.Catalog({
    name: "messages",
    path: "{locale}/messages",
    include: [],
    exclude: []
  }, (0, _jestMocks.mockConfig)(config));
};
exports.makeCatalog = makeCatalog;
function makePrevMessage(message = {}) {
  return {
    translation: "",
    ...makeNextMessage(message)
  };
}
function makeNextMessage(message = {}) {
  return {
    origin: [["catalog.test.ts", 1]],
    obsolete: false,
    ...message
  };
}