"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _fs = _interopRequireDefault(require("fs"));
var R = _interopRequireWildcard(require("ramda"));
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const removeOrigins = R.map(({
  origin,
  ...message
}) => message);
const removeLineNumbers = R.map(message => {
  if (message.origin) {
    message.origin.map(originValue => {
      originValue.pop();
      return originValue;
    });
  }
  return message;
});
const lingui = {
  catalogExtension: ".json",
  write(filename, catalog, options) {
    let outputCatalog = catalog;
    if (options.origins === false) {
      outputCatalog = removeOrigins(catalog);
    }
    if (options.origins !== false && options.lineNumbers === false) {
      outputCatalog = removeLineNumbers(outputCatalog);
    }
    (0, _utils.writeFileIfChanged)(filename, JSON.stringify(outputCatalog, null, 2));
  },
  read(filename) {
    const raw = _fs.default.readFileSync(filename).toString();
    try {
      return JSON.parse(raw);
    } catch (e) {
      throw new Error(`Cannot read ${filename}: ${e.message}`);
    }
  },
  parse(content) {
    return content;
  }
};
var _default = lingui;
exports.default = _default;