"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _papaparse = _interopRequireDefault(require("papaparse"));
var _utils = require("../utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const serialize = catalog => {
  const rawArr = Object.keys(catalog).map(key => [key, catalog[key].translation]);
  return _papaparse.default.unparse(rawArr);
};
const deserialize = raw => {
  const rawCatalog = _papaparse.default.parse(raw);
  const messages = {};
  if (rawCatalog.errors.length) {
    throw new Error(rawCatalog.errors.map(err => JSON.stringify(err)).join(";"));
  }
  rawCatalog.data.forEach(([key, translation]) => {
    messages[key] = {
      translation,
      obsolete: false,
      message: null,
      origin: []
    };
  });
  return messages;
};
const csv = {
  catalogExtension: ".csv",
  write(filename, catalog) {
    const messages = serialize(catalog);
    (0, _utils.writeFileIfChanged)(filename, messages);
  },
  read(filename) {
    const raw = _fs.default.readFileSync(filename).toString();
    try {
      return deserialize(raw);
    } catch (e) {
      throw new Error(`Cannot read ${filename}: ${e.message}`);
    }
  },
  parse(content) {
    return deserialize(content);
  }
};
var _default = csv;
exports.default = _default;