"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collect = collect;
exports.extract = extract;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _chalk = _interopRequireDefault(require("chalk"));
var R = _interopRequireWildcard(require("ramda"));
var _utils = require("./utils");
var _extractors = _interopRequireDefault(require("./extractors"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * Merge origins for messages found in different places. All other attributes
 * should be the same (raise an error if defaults are different).
 */
function mergeMessage(msgId, prev, next) {
  if (prev.message && next.message && prev.message !== next.message) {
    throw new Error(`Encountered different default translations for message ${_chalk.default.yellow(msgId)}` + `\n${_chalk.default.yellow((0, _utils.prettyOrigin)(prev.origin))} ${prev.message}` + `\n${_chalk.default.yellow((0, _utils.prettyOrigin)(next.origin))} ${next.message}`);
  }
  return {
    ...next,
    message: prev.message || next.message,
    origin: R.concat(prev.origin, next.origin)
  };
}
async function extract(srcPaths, targetPath, options = {}) {
  const {
    ignore = []
  } = options;
  const ignorePattern = ignore.length ? new RegExp(ignore.join("|"), "i") : null;
  for (let srcFilename of srcPaths) {
    if (!_fs.default.existsSync(srcFilename) || ignorePattern && ignorePattern.test(srcFilename)) continue;
    if (_fs.default.statSync(srcFilename).isDirectory()) {
      const subdirs = _fs.default.readdirSync(srcFilename).sort().map(filename => _path.default.join(srcFilename, filename));
      await extract(subdirs, targetPath, options);
      continue;
    }
    await (0, _extractors.default)(srcFilename, targetPath, options);
  }
}
function collect(buildDir) {
  return _fs.default.readdirSync(buildDir).sort().map(filename => {
    const filepath = _path.default.join(buildDir, filename);
    if (_fs.default.lstatSync(filepath).isDirectory()) {
      return collect(filepath);
    }
    if (!filename.endsWith(".json")) return;
    try {
      return JSON.parse(_fs.default.readFileSync(filepath).toString());
    } catch (e) {
      return {};
    }
  }).filter(Boolean).reduce((catalog, messages) => R.mergeWithKey(mergeMessage, catalog, messages), {});
}