"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detect = detect;
exports.projectType = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _pkgUp = _interopRequireDefault(require("pkg-up"));
var _package = _interopRequireDefault(require("../../package.json"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const projectType = {
  CRA: "CRA",
  REACT: "REACT"
};
exports.projectType = projectType;
function getPackageJson(cwd) {
  const packageJsonPath = _pkgUp.default.sync({
    cwd
  });
  try {
    const json = _fs.default.readFileSync(packageJsonPath, "utf8");
    return {
      path: packageJsonPath,
      content: JSON.parse(json)
    };
  } catch (e) {
    console.error(e);
    return null;
  }
}
function hasDependency(pkg, name) {
  return pkg.dependencies && pkg.dependencies[name] || pkg.devDependencies && pkg.devDependencies[name];
}
function detectFramework(pkg) {
  if (hasDependency(pkg, "react-scripts")) {
    return projectType.CRA;
  }
  if (hasDependency(pkg, "react")) {
    return projectType.REACT;
  }
  return null;
}
function detect() {
  let pkg = getPackageJson();
  if (!pkg) return null;
  if (pkg.content.name === _package.default.name) {
    pkg = getPackageJson(_path.default.dirname(pkg.path));
  }
  return detectFramework(pkg.content);
}