import 'package:flutter/material.dart';
import 'package:plant_it/l10n/generated/app_localizations.dart';

String colorToHex(Color color) {
  // ignore: deprecated_member_use
  return "#${color.red.toRadixString(16).padLeft(2, '0')}${color.green.toRadixString(16).padLeft(2, '0')}${color.blue.toRadixString(16).padLeft(2, '0')}";
}

Color hexToColor(String hexString) {
  hexString = hexString.replaceAll('#', '');
  if (hexString.length == 6) {
    hexString = 'FF$hexString';
  }
  return Color(int.parse('0x$hexString'));
}

String timeDiffStr(DateTime dateTime, L appLocalizations) {
  DateTime now = DateTime.now();
  Duration difference = now.difference(dateTime);

  bool isFuture = difference.isNegative;
  Duration duration = isFuture ? -difference : difference;

  if (duration.inDays >= 365) {
    int years = duration.inDays ~/ 365;
    return _buildTimeString(years, 'years', isFuture, appLocalizations);
  } else if (duration.inDays >= 30) {
    int months = duration.inDays ~/ 30;
    return _buildTimeString(months, 'months', isFuture, appLocalizations);
  } else if (duration.inDays >= 7) {
    int weeks = duration.inDays ~/ 7;
    return _buildTimeString(weeks, 'weeks', isFuture, appLocalizations);
  } else if (duration.inDays >= 1) {
    return _buildTimeString(duration.inDays, 'days', isFuture, appLocalizations);
  } else {
    if (now.day == dateTime.day) {
      return appLocalizations.today;
    } else {
      return difference.isNegative ? appLocalizations.tomorrow : appLocalizations.yesterday;
    }
  }
}

String _buildTimeString(int value, String unit, bool isFuture, L appLocalizations) {
  if (isFuture) {
    return appLocalizations.inTime(value, unit);
  } else {
    return appLocalizations.agoTime(value, unit);
  }
}
