import 'package:flutter/material.dart';

class CustomShape5 extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const CustomShape5({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _CustomShape5ShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _CustomShape5Painter(
            color: color,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
            gradient: gradient,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _CustomShape5Clipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _CustomShape5Painter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _CustomShape5Painter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildShape5Path(size);

    final paint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      paint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, paint);

    if (isStroked) {
      final strokePaint = Paint()
        ..color = strokeColor
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
}

class _CustomShape5ShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _CustomShape5ShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildShape5Path(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _CustomShape5Clipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildShape5Path(size);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildShape5Path(Size size) {
  Path path = Path();

  path.moveTo(size.width * 0.46, size.height * 0.06);
  path.cubicTo(
    size.width * 0.51,
    size.height * 0.03,
    size.width * 0.57,
    size.height * 0.03,
    size.width * 0.61,
    size.height * 0.06,
  );
  path.cubicTo(
    size.width * 0.64,
    size.height * 0.09,
    size.width * 0.67,
    size.height * 0.1,
    size.width * 0.71,
    size.height * 0.09,
  );
  path.cubicTo(
    size.width * 0.76,
    size.height * 0.08,
    size.width * 0.82,
    size.height * 0.11,
    size.width * 0.84,
    size.height * 0.17,
  );
  path.cubicTo(
    size.width * 0.85,
    size.height / 5,
    size.width * 0.88,
    size.height * 0.22,
    size.width * 0.91,
    size.height * 0.24,
  );
  path.cubicTo(
    size.width * 0.96,
    size.height / 4,
    size.width,
    size.height * 0.31,
    size.width * 0.98,
    size.height * 0.37,
  );
  path.cubicTo(
    size.width * 0.98,
    size.height * 0.4,
    size.width,
    size.height * 0.44,
    size.width,
    size.height * 0.46,
  );
  path.cubicTo(
    size.width * 1.05,
    size.height * 0.51,
    size.width * 1.05,
    size.height * 0.57,
    size.width,
    size.height * 0.61,
  );
  path.cubicTo(
    size.width,
    size.height * 0.64,
    size.width * 0.98,
    size.height * 0.67,
    size.width * 0.98,
    size.height * 0.71,
  );
  path.cubicTo(
    size.width,
    size.height * 0.76,
    size.width * 0.96,
    size.height * 0.82,
    size.width * 0.91,
    size.height * 0.84,
  );
  path.cubicTo(
    size.width * 0.88,
    size.height * 0.85,
    size.width * 0.85,
    size.height * 0.88,
    size.width * 0.84,
    size.height * 0.91,
  );
  path.cubicTo(
    size.width * 0.82,
    size.height * 0.96,
    size.width * 0.76,
    size.height,
    size.width * 0.71,
    size.height * 0.98,
  );
  path.cubicTo(
    size.width * 0.67,
    size.height * 0.98,
    size.width * 0.64,
    size.height,
    size.width * 0.61,
    size.height,
  );
  path.cubicTo(
    size.width * 0.57,
    size.height * 1.05,
    size.width * 0.51,
    size.height * 1.05,
    size.width * 0.46,
    size.height,
  );
  path.cubicTo(
    size.width * 0.44,
    size.height,
    size.width * 0.4,
    size.height * 0.98,
    size.width * 0.37,
    size.height * 0.98,
  );
  path.cubicTo(
    size.width * 0.31,
    size.height,
    size.width / 4,
    size.height * 0.96,
    size.width * 0.24,
    size.height * 0.91,
  );
  path.cubicTo(
    size.width * 0.22,
    size.height * 0.88,
    size.width / 5,
    size.height * 0.85,
    size.width * 0.17,
    size.height * 0.84,
  );
  path.cubicTo(
    size.width * 0.11,
    size.height * 0.82,
    size.width * 0.08,
    size.height * 0.76,
    size.width * 0.09,
    size.height * 0.71,
  );
  path.cubicTo(
    size.width * 0.1,
    size.height * 0.67,
    size.width * 0.09,
    size.height * 0.64,
    size.width * 0.06,
    size.height * 0.61,
  );
  path.cubicTo(
    size.width * 0.03,
    size.height * 0.57,
    size.width * 0.03,
    size.height * 0.51,
    size.width * 0.06,
    size.height * 0.46,
  );
  path.cubicTo(
    size.width * 0.09,
    size.height * 0.44,
    size.width * 0.1,
    size.height * 0.4,
    size.width * 0.09,
    size.height * 0.37,
  );
  path.cubicTo(
    size.width * 0.08,
    size.height * 0.31,
    size.width * 0.11,
    size.height / 4,
    size.width * 0.17,
    size.height * 0.24,
  );
  path.cubicTo(
    size.width / 5,
    size.height * 0.22,
    size.width * 0.22,
    size.height / 5,
    size.width * 0.24,
    size.height * 0.17,
  );
  path.cubicTo(
    size.width / 4,
    size.height * 0.11,
    size.width * 0.31,
    size.height * 0.08,
    size.width * 0.37,
    size.height * 0.09,
  );
  path.cubicTo(
    size.width * 0.4,
    size.height * 0.1,
    size.width * 0.44,
    size.height * 0.09,
    size.width * 0.46,
    size.height * 0.06,
  );
  path.close();

  return path;
}
