import 'package:flutter/material.dart';

class CustomShape1 extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const CustomShape1({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _CustomShape1ShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _CustomShape1Painter(
            color: color,
            gradient: gradient,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _CustomShape1Clipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _CustomShape1Painter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _CustomShape1Painter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildCustomShape1Path(size);
    final fillPaint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      fillPaint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, fillPaint);

    if (isStroked) {
      final strokePaint = Paint()
        ..color = strokeColor
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
}

class _CustomShape1ShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _CustomShape1ShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildCustomShape1Path(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _CustomShape1Clipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildCustomShape1Path(size);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildCustomShape1Path(Size size) {
  Path path = Path();

  // Converted directly from your MyPainter code
  path.moveTo(size.width * 0.49, size.height * 0.04);
  path.cubicTo(
    size.width * 0.51,
    size.height * 0.02,
    size.width * 0.54,
    size.height * 0.02,
    size.width * 0.56,
    size.height * 0.04,
  );
  path.cubicTo(
    size.width * 0.56,
    size.height * 0.04,
    size.width * 0.61,
    size.height * 0.11,
    size.width * 0.61,
    size.height * 0.11,
  );
  path.cubicTo(
    size.width * 0.62,
    size.height * 0.13,
    size.width * 0.64,
    size.height * 0.13,
    size.width * 0.66,
    size.height * 0.13,
  );
  path.cubicTo(
    size.width * 0.66,
    size.height * 0.13,
    size.width * 0.74,
    size.height * 0.09,
    size.width * 0.74,
    size.height * 0.09,
  );
  path.cubicTo(
    size.width * 0.77,
    size.height * 0.08,
    size.width * 0.79,
    size.height * 0.1,
    size.width * 0.8,
    size.height * 0.13,
  );
  path.cubicTo(
    size.width * 0.8,
    size.height * 0.13,
    size.width * 0.81,
    size.height / 5,
    size.width * 0.81,
    size.height / 5,
  );
  path.cubicTo(
    size.width * 0.81,
    size.height * 0.23,
    size.width * 0.83,
    size.height * 0.24,
    size.width * 0.85,
    size.height / 4,
  );
  path.cubicTo(
    size.width * 0.85,
    size.height / 4,
    size.width * 0.93,
    size.height * 0.26,
    size.width * 0.93,
    size.height * 0.26,
  );
  path.cubicTo(
    size.width * 0.96,
    size.height * 0.26,
    size.width * 0.97,
    size.height * 0.29,
    size.width * 0.96,
    size.height * 0.32,
  );
  path.cubicTo(
    size.width * 0.96,
    size.height * 0.32,
    size.width * 0.93,
    size.height * 0.39,
    size.width * 0.93,
    size.height * 0.39,
  );
  path.cubicTo(
    size.width * 0.92,
    size.height * 0.41,
    size.width * 0.93,
    size.height * 0.43,
    size.width * 0.94,
    size.height * 0.44,
  );
  path.cubicTo(
    size.width * 0.94,
    size.height * 0.44,
    size.width,
    size.height * 0.49,
    size.width,
    size.height * 0.49,
  );
  path.cubicTo(
    size.width * 1.03,
    size.height * 0.51,
    size.width * 1.03,
    size.height * 0.54,
    size.width,
    size.height * 0.56,
  );
  path.cubicTo(
    size.width,
    size.height * 0.56,
    size.width * 0.94,
    size.height * 0.61,
    size.width * 0.94,
    size.height * 0.61,
  );
  path.cubicTo(
    size.width * 0.93,
    size.height * 0.62,
    size.width * 0.92,
    size.height * 0.64,
    size.width * 0.93,
    size.height * 0.66,
  );
  path.cubicTo(
    size.width * 0.93,
    size.height * 0.66,
    size.width * 0.96,
    size.height * 0.74,
    size.width * 0.96,
    size.height * 0.74,
  );
  path.cubicTo(
    size.width * 0.97,
    size.height * 0.77,
    size.width * 0.96,
    size.height * 0.79,
    size.width * 0.93,
    size.height * 0.8,
  );
  path.cubicTo(
    size.width * 0.93,
    size.height * 0.8,
    size.width * 0.85,
    size.height * 0.81,
    size.width * 0.85,
    size.height * 0.81,
  );
  path.cubicTo(
    size.width * 0.83,
    size.height * 0.81,
    size.width * 0.81,
    size.height * 0.83,
    size.width * 0.81,
    size.height * 0.85,
  );
  path.cubicTo(
    size.width * 0.81,
    size.height * 0.85,
    size.width * 0.8,
    size.height * 0.93,
    size.width * 0.8,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width * 0.79,
    size.height * 0.96,
    size.width * 0.77,
    size.height * 0.97,
    size.width * 0.74,
    size.height * 0.96,
  );
  path.cubicTo(
    size.width * 0.74,
    size.height * 0.96,
    size.width * 0.66,
    size.height * 0.93,
    size.width * 0.66,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width * 0.64,
    size.height * 0.92,
    size.width * 0.62,
    size.height * 0.93,
    size.width * 0.61,
    size.height * 0.94,
  );
  path.cubicTo(
    size.width * 0.61,
    size.height * 0.94,
    size.width * 0.56,
    size.height,
    size.width * 0.56,
    size.height,
  );
  path.cubicTo(
    size.width * 0.54,
    size.height * 1.03,
    size.width * 0.51,
    size.height * 1.03,
    size.width * 0.49,
    size.height,
  );
  path.cubicTo(
    size.width * 0.49,
    size.height,
    size.width * 0.44,
    size.height * 0.94,
    size.width * 0.44,
    size.height * 0.94,
  );
  path.cubicTo(
    size.width * 0.43,
    size.height * 0.93,
    size.width * 0.41,
    size.height * 0.92,
    size.width * 0.39,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width * 0.39,
    size.height * 0.93,
    size.width * 0.32,
    size.height * 0.96,
    size.width * 0.32,
    size.height * 0.96,
  );
  path.cubicTo(
    size.width * 0.29,
    size.height * 0.97,
    size.width * 0.26,
    size.height * 0.96,
    size.width * 0.26,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width * 0.26,
    size.height * 0.93,
    size.width / 4,
    size.height * 0.85,
    size.width / 4,
    size.height * 0.85,
  );
  path.cubicTo(
    size.width * 0.24,
    size.height * 0.83,
    size.width * 0.23,
    size.height * 0.81,
    size.width / 5,
    size.height * 0.81,
  );
  path.cubicTo(
    size.width / 5,
    size.height * 0.81,
    size.width * 0.13,
    size.height * 0.8,
    size.width * 0.13,
    size.height * 0.8,
  );
  path.cubicTo(
    size.width * 0.1,
    size.height * 0.79,
    size.width * 0.08,
    size.height * 0.77,
    size.width * 0.09,
    size.height * 0.74,
  );
  path.cubicTo(
    size.width * 0.09,
    size.height * 0.74,
    size.width * 0.13,
    size.height * 0.66,
    size.width * 0.13,
    size.height * 0.66,
  );
  path.cubicTo(
    size.width * 0.13,
    size.height * 0.64,
    size.width * 0.13,
    size.height * 0.62,
    size.width * 0.11,
    size.height * 0.61,
  );
  path.cubicTo(
    size.width * 0.11,
    size.height * 0.61,
    size.width * 0.04,
    size.height * 0.56,
    size.width * 0.04,
    size.height * 0.56,
  );
  path.cubicTo(
    size.width * 0.02,
    size.height * 0.54,
    size.width * 0.02,
    size.height * 0.51,
    size.width * 0.04,
    size.height * 0.49,
  );
  path.cubicTo(
    size.width * 0.04,
    size.height * 0.49,
    size.width * 0.11,
    size.height * 0.44,
    size.width * 0.11,
    size.height * 0.44,
  );
  path.cubicTo(
    size.width * 0.13,
    size.height * 0.43,
    size.width * 0.13,
    size.height * 0.41,
    size.width * 0.13,
    size.height * 0.39,
  );
  path.cubicTo(
    size.width * 0.13,
    size.height * 0.39,
    size.width * 0.09,
    size.height * 0.32,
    size.width * 0.09,
    size.height * 0.32,
  );
  path.cubicTo(
    size.width * 0.08,
    size.height * 0.29,
    size.width * 0.1,
    size.height * 0.26,
    size.width * 0.13,
    size.height * 0.26,
  );
  path.cubicTo(
    size.width * 0.13,
    size.height * 0.26,
    size.width / 5,
    size.height / 4,
    size.width / 5,
    size.height / 4,
  );
  path.cubicTo(
    size.width * 0.23,
    size.height * 0.24,
    size.width * 0.24,
    size.height * 0.23,
    size.width / 4,
    size.height / 5,
  );
  path.cubicTo(
    size.width / 4,
    size.height / 5,
    size.width * 0.26,
    size.height * 0.13,
    size.width * 0.26,
    size.height * 0.13,
  );
  path.cubicTo(
    size.width * 0.26,
    size.height * 0.1,
    size.width * 0.29,
    size.height * 0.08,
    size.width * 0.32,
    size.height * 0.09,
  );
  path.cubicTo(
    size.width * 0.32,
    size.height * 0.09,
    size.width * 0.39,
    size.height * 0.13,
    size.width * 0.39,
    size.height * 0.13,
  );
  path.cubicTo(
    size.width * 0.41,
    size.height * 0.13,
    size.width * 0.43,
    size.height * 0.13,
    size.width * 0.44,
    size.height * 0.11,
  );
  path.cubicTo(
    size.width * 0.44,
    size.height * 0.11,
    size.width * 0.49,
    size.height * 0.04,
    size.width * 0.49,
    size.height * 0.04,
  );
  path.close();

  return path;
}
