import 'package:flutter/material.dart';

class CustomShape8 extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const CustomShape8({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _CustomShape8ShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _CustomShape8Painter(
            color: color,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
            gradient: gradient,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _CustomShape8Clipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _CustomShape8Painter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _CustomShape8Painter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildShape8Path(size);

    final paint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      paint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, paint);

    if (isStroked) {
      final strokePaint = Paint()
        ..color = strokeColor
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
}

class _CustomShape8ShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _CustomShape8ShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildShape8Path(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _CustomShape8Clipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildShape8Path(size);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildShape8Path(Size size) {
  Path path = Path();
  path.moveTo(size.width * 0.32, size.height * 0.07);
  path.cubicTo(
    size.width * 0.42,
    -0.02,
    size.width * 0.58,
    -0.02,
    size.width * 0.68,
    size.height * 0.07,
  );
  path.cubicTo(
    size.width * 0.72,
    size.height * 0.11,
    size.width * 0.76,
    size.height * 0.13,
    size.width * 0.81,
    size.height * 0.14,
  );
  path.cubicTo(
    size.width * 0.95,
    size.height * 0.17,
    size.width * 1.03,
    size.height * 0.31,
    size.width,
    size.height * 0.44,
  );
  path.cubicTo(
    size.width * 0.98,
    size.height * 0.48,
    size.width * 0.98,
    size.height * 0.52,
    size.width,
    size.height * 0.57,
  );
  path.cubicTo(
    size.width * 1.03,
    size.height * 0.7,
    size.width * 0.95,
    size.height * 0.83,
    size.width * 0.81,
    size.height * 0.86,
  );
  path.cubicTo(
    size.width * 0.76,
    size.height * 0.87,
    size.width * 0.72,
    size.height * 0.9,
    size.width * 0.68,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width * 0.58,
    size.height * 1.03,
    size.width * 0.42,
    size.height * 1.03,
    size.width * 0.32,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width * 0.28,
    size.height * 0.9,
    size.width * 0.24,
    size.height * 0.87,
    size.width * 0.19,
    size.height * 0.86,
  );
  path.cubicTo(
    size.width * 0.05,
    size.height * 0.83,
    -0.03,
    size.height * 0.7,
    size.width * 0.01,
    size.height * 0.57,
  );
  path.cubicTo(
    size.width * 0.02,
    size.height * 0.52,
    size.width * 0.02,
    size.height * 0.48,
    size.width * 0.01,
    size.height * 0.44,
  );
  path.cubicTo(
    -0.03,
    size.height * 0.31,
    size.width * 0.05,
    size.height * 0.17,
    size.width * 0.19,
    size.height * 0.14,
  );
  path.cubicTo(
    size.width * 0.24,
    size.height * 0.13,
    size.width * 0.28,
    size.height * 0.11,
    size.width * 0.32,
    size.height * 0.07,
  );
  path.close();
  return path;
}
