import 'package:flutter/material.dart';

class CustomShape7 extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const CustomShape7({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(size, size),
            painter: _CustomShape7ShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(size, size),
          painter: _CustomShape7Painter(
            color: color,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
            gradient: gradient,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _CustomShape7Clipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: size,
                    height: size,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: size, height: size, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size, child: shape),
    );
  }
}

class _CustomShape7Painter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _CustomShape7Painter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildShape7Path(size);

    final paint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      paint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, paint);

    if (isStroked) {
      final strokePaint = Paint()
        ..color = strokeColor
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => true;
}

class _CustomShape7ShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _CustomShape7ShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildShape7Path(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}

class _CustomShape7Clipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildShape7Path(size);

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}

Path _buildShape7Path(Size size) {
  Path path = Path();
  path.moveTo(size.width * 0.43, size.height * 0.13);
  path.cubicTo(
    size.width * 0.51,
    size.height * 0.05,
    size.width * 0.64,
    size.height * 0.05,
    size.width * 0.73,
    size.height * 0.13,
  );
  path.cubicTo(
    size.width * 0.76,
    size.height * 0.16,
    size.width * 0.8,
    size.height * 0.17,
    size.width * 0.83,
    size.height * 0.18,
  );
  path.cubicTo(
    size.width * 0.95,
    size.height / 5,
    size.width * 1.03,
    size.height * 0.3,
    size.width * 1.02,
    size.height * 0.42,
  );
  path.cubicTo(
    size.width * 1.03,
    size.height / 2,
    size.width * 1.05,
    size.height * 0.54,
    size.width * 1.05,
    size.height * 0.54,
  );
  path.cubicTo(
    size.width * 1.1,
    size.height * 0.64,
    size.width * 1.08,
    size.height * 0.77,
    size.width,
    size.height * 0.83,
  );
  path.cubicTo(
    size.width * 0.98,
    size.height * 0.84,
    size.width * 0.95,
    size.height * 0.86,
    size.width * 0.91,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width * 0.86,
    size.height * 1.04,
    size.width * 0.75,
    size.height * 1.09,
    size.width * 0.64,
    size.height * 1.06,
  );
  path.cubicTo(
    size.width * 0.6,
    size.height * 1.05,
    size.width * 0.56,
    size.height * 1.05,
    size.width * 0.52,
    size.height * 1.06,
  );
  path.cubicTo(
    size.width * 0.41,
    size.height * 1.09,
    size.width * 0.29,
    size.height * 1.04,
    size.width / 4,
    size.height * 0.93,
  );
  path.cubicTo(
    size.width / 5,
    size.height * 0.86,
    size.width * 0.17,
    size.height * 0.84,
    size.width * 0.17,
    size.height * 0.83,
  );
  path.cubicTo(
    size.width * 0.08,
    size.height * 0.77,
    size.width * 0.05,
    size.height * 0.64,
    size.width * 0.1,
    size.height * 0.54,
  );
  path.cubicTo(
    size.width * 0.12,
    size.height / 2,
    size.width * 0.13,
    size.height * 0.46,
    size.width * 0.13,
    size.height * 0.42,
  );
  path.cubicTo(
    size.width * 0.13,
    size.height * 0.3,
    size.width / 5,
    size.height / 5,
    size.width * 0.32,
    size.height * 0.18,
  );
  path.cubicTo(
    size.width * 0.36,
    size.height * 0.17,
    size.width * 0.4,
    size.height * 0.16,
    size.width * 0.42,
    size.height * 0.13,
  );
  path.close();
  return path;
}
