// import 'package:flutter/material.dart';

// class OrganicBlobShape extends StatelessWidget {
//   final double size;
//   final Color color;
//   final bool isStroked;
//   final Color? strokeColor;
//   final double strokeWidth;
//   final ImageProvider? image;
//   final BoxFit imageFit;
//   final Alignment imageAlignment;
//   final double imageScale;
//   final Color? overlayColor;
//   final Gradient? gradient;
//   final BoxShadow? shadow;
//   final VoidCallback? onTap;

//   const OrganicBlobShape({
//     super.key,
//     required this.size,
//     required this.color,
//     this.isStroked = false,
//     this.strokeColor,
//     this.strokeWidth = 2.0,
//     this.image,
//     this.imageFit = BoxFit.cover,
//     this.imageAlignment = Alignment.center,
//     this.imageScale = 1.0,
//     this.overlayColor,
//     this.gradient,
//     this.shadow,
//     this.onTap,
//   });

//   @override
//   Widget build(BuildContext context) {
//     final Widget shape = Stack(
//       alignment: Alignment.center,
//       children: [
//         if (shadow != null)
//           CustomPaint(
//             size: Size(size, size),
//             painter: _OrganicBlobShadowPainter(shadow!),
//           ),
//         CustomPaint(
//           size: Size(size, size),
//           painter: _OrganicBlobPainter(
//             color: color,
//             gradient: gradient,
//             isStroked: isStroked,
//             strokeColor: strokeColor ?? Colors.black,
//             strokeWidth: strokeWidth,
//           ),
//         ),
//         if (image != null)
//           ClipPath(
//             clipper: _OrganicBlobClipper(),
//             child: Stack(
//               children: [
//                 Transform.scale(
//                   scale: imageScale,
//                   child: Image(
//                     image: image!,
//                     width: size,
//                     height: size,
//                     fit: imageFit,
//                     alignment: imageAlignment,
//                   ),
//                 ),
//                 if (overlayColor != null)
//                   Container(width: size, height: size, color: overlayColor),
//               ],
//             ),
//           ),
//       ],
//     );

//     return GestureDetector(
//       onTap: onTap,
//       child: SizedBox(width: size, height: size, child: shape),
//     );
//   }
// }

// class _OrganicBlobPainter extends CustomPainter {
//   final Color color;
//   final bool isStroked;
//   final Color strokeColor;
//   final double strokeWidth;
//   final Gradient? gradient;

//   const _OrganicBlobPainter({
//     required this.color,
//     required this.isStroked,
//     required this.strokeColor,
//     required this.strokeWidth,
//     this.gradient,
//   });

//   @override
//   void paint(Canvas canvas, Size size) {
//     final path = _buildOrganicBlobPath(size);

//     final fillPaint = Paint()
//       ..style = PaintingStyle.fill
//       ..color = color;

//     if (gradient != null) {
//       fillPaint.shader = gradient!.createShader(
//         Rect.fromLTWH(0, 0, size.width, size.height),
//       );
//     }

//     canvas.drawPath(path, fillPaint);

//     if (isStroked) {
//       final strokePaint = Paint()
//         ..color = strokeColor
//         ..style = PaintingStyle.stroke
//         ..strokeWidth = strokeWidth;
//       canvas.drawPath(path, strokePaint);
//     }
//   }

//   @override
//   bool shouldRepaint(CustomPainter oldDelegate) => true;
// }

// class _OrganicBlobShadowPainter extends CustomPainter {
//   final BoxShadow shadow;

//   const _OrganicBlobShadowPainter(this.shadow);

//   @override
//   void paint(Canvas canvas, Size size) {
//     final path = _buildOrganicBlobPath(size);
//     final paint = shadow.toPaint();
//     canvas.drawPath(path.shift(shadow.offset), paint);
//   }

//   @override
//   bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
// }

// class _OrganicBlobClipper extends CustomClipper<Path> {
//   @override
//   Path getClip(Size size) => _buildOrganicBlobPath(size);

//   @override
//   bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
// }

// Path _buildOrganicBlobPath(Size size) {
//   final path = Path();
//   path.moveTo(0, 0);
//   path.moveTo(size.width * 0.95, size.height);
//   path.cubicTo(
//     size.width * 0.98,
//     size.height,
//     size.width,
//     size.height * 0.95,
//     size.width,
//     size.height * 0.88,
//   );
//   path.cubicTo(
//     size.width,
//     size.height * 0.66,
//     size.width * 0.94,
//     size.height * 0.45,
//     size.width * 0.86,
//     size.height * 0.29,
//   );
//   path.cubicTo(
//     size.width * 0.76,
//     size.height * 0.11,
//     size.width * 0.64,
//     0,
//     size.width / 2,
//     0,
//   );
//   path.cubicTo(
//     size.width * 0.37,
//     0,
//     size.width * 0.24,
//     size.height * 0.11,
//     size.width * 0.15,
//     size.height * 0.29,
//   );
//   path.cubicTo(
//     size.width * 0.07,
//     size.height * 0.45,
//     size.width * 0.02,
//     size.height * 0.66,
//     0,
//     size.height * 0.88,
//   );
//   path.cubicTo(
//     0,
//     size.height * 0.95,
//     size.width * 0.03,
//     size.height,
//     size.width * 0.06,
//     size.height,
//   );
//   path.cubicTo(
//     size.width * 0.06,
//     size.height,
//     size.width / 2,
//     size.height,
//     size.width / 2,
//     size.height,
//   );
//   path.cubicTo(
//     size.width / 2,
//     size.height,
//     size.width * 0.95,
//     size.height,
//     size.width * 0.95,
//     size.height,
//   );
//   return path;
// }
import 'package:flutter/material.dart';

class RoundedHalfCircleShape extends StatelessWidget {
  final double width;
  final double height;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const RoundedHalfCircleShape({
    Key? key,
    required this.width,
    required this.height,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    final Widget shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          CustomPaint(
            size: Size(width, height),
            painter: _RoundedHalfCircleShadowPainter(shadow!),
          ),
        CustomPaint(
          size: Size(width, height),
          painter: _RoundedHalfCirclePainter(
            color: color,
            gradient: gradient,
            isStroked: isStroked,
            strokeColor: strokeColor ?? Colors.black,
            strokeWidth: strokeWidth,
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _RoundedHalfCircleClipper(),
            child: Stack(
              children: [
                Transform.scale(
                  scale: imageScale,
                  child: Image(
                    image: image!,
                    width: width,
                    height: height,
                    fit: imageFit,
                    alignment: imageAlignment,
                  ),
                ),
                if (overlayColor != null)
                  Container(width: width, height: height, color: overlayColor),
              ],
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: width, height: height, child: shape),
    );
  }
}

class _RoundedHalfCirclePainter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _RoundedHalfCirclePainter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildRoundedHalfCirclePath(size);

    final fillPaint = Paint()
      ..style = PaintingStyle.fill
      ..color = color;

    if (gradient != null) {
      fillPaint.shader = gradient!.createShader(
        Rect.fromLTWH(0, 0, size.width, size.height),
      );
    }

    canvas.drawPath(path, fillPaint);

    if (isStroked) {
      final strokePaint = Paint()
        ..color = strokeColor
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth;
      canvas.drawPath(path, strokePaint);
    }
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => true;
}

class _RoundedHalfCircleShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _RoundedHalfCircleShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final path = _buildRoundedHalfCirclePath(size);
    final paint = shadow.toPaint();
    canvas.drawPath(path.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => false;
}

class _RoundedHalfCircleClipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) => _buildRoundedHalfCirclePath(size);

  @override
  bool shouldReclip(CustomClipper<Path> oldClipper) => false;
}

Path _buildRoundedHalfCirclePath(Size size) {
  final path = Path();
  const radius = 20.0;

  // Start from bottom-left with corner radius
  path.moveTo(0, size.height - radius);
  path.quadraticBezierTo(0, size.height, radius, size.height);

  // Bottom edge
  path.lineTo(size.width - radius, size.height);
  path.quadraticBezierTo(
    size.width,
    size.height,
    size.width,
    size.height - radius,
  );

  // Top arc - semicircle
  path.arcToPoint(
    Offset(0, size.height - radius),
    radius: Radius.circular(size.width / 2),
    clockwise: false,
  );

  path.close();
  return path;
}
