// import 'package:flutter/material.dart';

// class TallRectangleShape extends StatelessWidget {
//   final double size;
//   final Color color;
//   final bool isStroked;
//   final Color? strokeColor;
//   final double strokeWidth;
//   final ImageProvider? image;
//   final BoxFit imageFit;
//   final Alignment imageAlignment;
//   final double imageScale;
//   final Color? overlayColor;
//   final Gradient? gradient;
//   final BoxShadow? shadow;
//   final VoidCallback? onTap;

//   const TallRectangleShape({
//     super.key,
//     required this.size,
//     required this.color,
//     this.isStroked = false,
//     this.strokeColor,
//     this.strokeWidth = 2.0,
//     this.image,
//     this.imageFit = BoxFit.cover,
//     this.imageAlignment = Alignment.center,
//     this.imageScale = 1.0,
//     this.overlayColor,
//     this.gradient,
//     this.shadow,
//     this.onTap,
//   });

//   @override
//   Widget build(BuildContext context) {
//     final Widget rectangle = Stack(
//       alignment: Alignment.center,
//       children: [
//         if (shadow != null)
//           CustomPaint(
//             size: Size(size, size),
//             painter: _TallRectangleShadowPainter(shadow!),
//           ),
//         CustomPaint(
//           size: Size(size, size),
//           painter: _TallRectanglePainter(
//             color: color,
//             gradient: gradient,
//             isStroked: isStroked,
//             strokeColor: strokeColor ?? Colors.black,
//             strokeWidth: strokeWidth,
//           ),
//         ),
//         if (image != null)
//           ClipPath(
//             clipper: _TallRectangleClipper(),
//             child: Stack(
//               children: [
//                 Transform.scale(
//                   scale: imageScale,
//                   child: Image(
//                     image: image!,
//                     width: size,
//                     height: size,
//                     fit: imageFit,
//                     alignment: imageAlignment,
//                   ),
//                 ),
//                 if (overlayColor != null)
//                   Container(width: size, height: size, color: overlayColor),
//               ],
//             ),
//           ),
//       ],
//     );

//     return GestureDetector(
//       onTap: onTap,
//       child: SizedBox(width: size, height: size, child: rectangle),
//     );
//   }
// }

// class _TallRectanglePainter extends CustomPainter {
//   final Color color;
//   final bool isStroked;
//   final Color strokeColor;
//   final double strokeWidth;
//   final Gradient? gradient;

//   const _TallRectanglePainter({
//     required this.color,
//     required this.isStroked,
//     required this.strokeColor,
//     required this.strokeWidth,
//     this.gradient,
//   });

//   @override
//   void paint(Canvas canvas, Size size) {
//     final path = _buildTallRectanglePath(size);

//     final fillPaint = Paint()
//       ..style = PaintingStyle.fill
//       ..color = color;

//     if (gradient != null) {
//       fillPaint.shader = gradient!.createShader(
//         Rect.fromLTWH(0, 0, size.width, size.height),
//       );
//     }

//     canvas.drawPath(path, fillPaint);

//     if (isStroked) {
//       final strokePaint = Paint()
//         ..color = strokeColor
//         ..style = PaintingStyle.stroke
//         ..strokeWidth = strokeWidth;
//       canvas.drawPath(path, strokePaint);
//     }
//   }

//   @override
//   bool shouldRepaint(CustomPainter oldDelegate) => true;
// }

// class _TallRectangleShadowPainter extends CustomPainter {
//   final BoxShadow shadow;

//   const _TallRectangleShadowPainter(this.shadow);

//   @override
//   void paint(Canvas canvas, Size size) {
//     final path = _buildTallRectanglePath(size);
//     final paint = shadow.toPaint();
//     canvas.drawPath(path.shift(shadow.offset), paint);
//   }

//   @override
//   bool shouldRepaint(CustomPainter oldDelegate) => false;
// }

// class _TallRectangleClipper extends CustomClipper<Path> {
//   @override
//   Path getClip(Size size) => _buildTallRectanglePath(size);

//   @override
//   bool shouldReclip(CustomClipper<Path> oldClipper) => false;
// }

// Path _buildTallRectanglePath(Size size) {
//   final Path path = Path();
//   path.moveTo(size.width * 1.8, -0.15);
//   path.cubicTo(
//     size.width * 1.8,
//     -0.15,
//     size.width * 2.8,
//     -0.15,
//     size.width * 2.8,
//     -0.15,
//   );
//   path.cubicTo(
//     size.width * 2.8,
//     -0.15,
//     size.width * 2.8,
//     size.height * 0.85,
//     size.width * 2.8,
//     size.height * 0.85,
//   );
//   path.cubicTo(
//     size.width * 2.8,
//     size.height * 0.85,
//     size.width * 1.8,
//     size.height * 0.85,
//     size.width * 1.8,
//     size.height * 0.85,
//   );
//   path.cubicTo(
//     size.width * 1.8,
//     size.height * 0.85,
//     size.width * 1.8,
//     -0.15,
//     size.width * 1.8,
//     -0.15,
//   );
//   path.close();
//   return path;
// }

import 'package:flutter/material.dart';
import 'dart:math';

class RotatedTallRoundedRectangleShape extends StatelessWidget {
  final double size;
  final Color color;
  final bool isStroked;
  final Color? strokeColor;
  final double strokeWidth;
  final ImageProvider? image;
  final BoxFit imageFit;
  final Alignment imageAlignment;
  final double imageScale;
  final Color? overlayColor;
  final Gradient? gradient;
  final BoxShadow? shadow;
  final VoidCallback? onTap;

  const RotatedTallRoundedRectangleShape({
    super.key,
    required this.size,
    required this.color,
    this.isStroked = false,
    this.strokeColor,
    this.strokeWidth = 2.0,
    this.image,
    this.imageFit = BoxFit.cover,
    this.imageAlignment = Alignment.center,
    this.imageScale = 1.0,
    this.overlayColor,
    this.gradient,
    this.shadow,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final Widget shape = Stack(
      alignment: Alignment.center,
      children: [
        if (shadow != null)
          Transform.rotate(
            angle: pi / 4,
            child: CustomPaint(
              size: Size(size, size * 1.4),
              painter: _RotatedRoundedRectShadowPainter(shadow!),
            ),
          ),
        Transform.rotate(
          angle: pi / 4,
          child: CustomPaint(
            size: Size(size, size * 1.4),
            painter: _RotatedRoundedRectPainter(
              color: color,
              isStroked: isStroked,
              strokeColor: strokeColor ?? Colors.black,
              strokeWidth: strokeWidth,
              gradient: gradient,
            ),
          ),
        ),
        if (image != null)
          ClipPath(
            clipper: _RotatedRoundedRectClipper(),
            child: Transform.rotate(
              angle: pi / 4,
              child: Stack(
                children: [
                  Transform.scale(
                    scale: imageScale,
                    child: Image(
                      image: image!,
                      width: size,
                      height: size * 1.4,
                      fit: imageFit,
                      alignment: imageAlignment,
                    ),
                  ),
                  if (overlayColor != null)
                    Container(
                      width: size,
                      height: size * 1.4,
                      color: overlayColor,
                    ),
                ],
              ),
            ),
          ),
      ],
    );

    return GestureDetector(
      onTap: onTap,
      child: SizedBox(width: size, height: size * 1.4, child: shape),
    );
  }
}

class _RotatedRoundedRectPainter extends CustomPainter {
  final Color color;
  final bool isStroked;
  final Color strokeColor;
  final double strokeWidth;
  final Gradient? gradient;

  const _RotatedRoundedRectPainter({
    required this.color,
    required this.isStroked,
    required this.strokeColor,
    required this.strokeWidth,
    this.gradient,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final rect = Rect.fromLTWH(0, 0, size.width, size.height);
    final radius = Radius.circular(min(size.width, size.height) / 2);
    final rrect = RRect.fromRectAndRadius(rect, radius);

    final fillPaint = Paint()..style = PaintingStyle.fill;

    if (gradient != null) {
      fillPaint.shader = gradient!.createShader(rect);
    } else {
      fillPaint.color = color;
    }

    canvas.drawRRect(rrect, fillPaint);

    if (isStroked) {
      final strokePaint = Paint()
        ..style = PaintingStyle.stroke
        ..strokeWidth = strokeWidth
        ..color = strokeColor;
      canvas.drawRRect(rrect, strokePaint);
    }
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => true;
}

class _RotatedRoundedRectShadowPainter extends CustomPainter {
  final BoxShadow shadow;

  const _RotatedRoundedRectShadowPainter(this.shadow);

  @override
  void paint(Canvas canvas, Size size) {
    final rect = Rect.fromLTWH(0, 0, size.width, size.height);
    final radius = Radius.circular(min(size.width, size.height) / 2);
    final rrect = RRect.fromRectAndRadius(rect, radius);
    final paint = shadow.toPaint();
    canvas.drawRRect(rrect.shift(shadow.offset), paint);
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => false;
}

class _RotatedRoundedRectClipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) {
    final rect = Rect.fromLTWH(0, 0, size.width, size.height);
    final radius = Radius.circular(min(size.width, size.height) / 2);
    final rrect = RRect.fromRectAndRadius(rect, radius);
    return Path()..addRRect(rrect);
  }

  @override
  bool shouldReclip(CustomClipper<Path> oldClipper) => false;
}
